/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal;

import com.bolyuba.nexus.plugin.npm.NpmRepository;
import com.bolyuba.nexus.plugin.npm.hosted.NpmHostedRepository;
import com.bolyuba.nexus.plugin.npm.service.HostedMetadataService;
import com.bolyuba.nexus.plugin.npm.service.PackageRequest;
import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.bolyuba.nexus.plugin.npm.service.internal.GeneratorWithStoreSupport;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataParser;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataStore;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import org.sonatype.nexus.proxy.item.ContentLocator;

public class HostedMetadataServiceImpl
extends GeneratorWithStoreSupport<NpmHostedRepository>
implements HostedMetadataService {
    public HostedMetadataServiceImpl(NpmHostedRepository npmHostedRepository, MetadataStore metadataStore, MetadataParser metadataParser) {
        super(npmHostedRepository, metadataParser, metadataStore);
    }

    @Override
    public boolean deleteAllMetadata() {
        this.log.info("Deleting all hosted npm metadata from {}", (Object)((NpmHostedRepository)this.getNpmRepository()).getId());
        return this.metadataStore.deletePackages((NpmRepository)this.getNpmRepository());
    }

    @Override
    public boolean deletePackage(String packageName) {
        Preconditions.checkNotNull((Object)packageName, (Object)"null package name");
        this.log.info("Deleting hosted npm package {} metadata from {}", (Object)packageName, (Object)((NpmHostedRepository)this.getNpmRepository()).getId());
        return this.metadataStore.deletePackageByName((NpmRepository)this.getNpmRepository(), packageName);
    }

    @Override
    public PackageRoot parsePackageRoot(PackageRequest request, ContentLocator contentLocator) throws IOException {
        Preconditions.checkArgument((boolean)request.isPackageRoot(), (String)"Package root request expected, but got %s", (Object[])new Object[]{request.getPath()});
        PackageRoot packageRoot = this.metadataParser.parsePackageRoot(((NpmHostedRepository)this.getNpmRepository()).getId(), contentLocator);
        Preconditions.checkArgument((boolean)request.getName().equals(packageRoot.getName()), (String)"Package root name '%s' and parsed content name '%s' mismatch", (Object[])new Object[]{request.getName(), packageRoot.getName()});
        Preconditions.checkArgument((!packageRoot.isIncomplete() ? 1 : 0) != 0, (Object)"Incomplete package root parsed");
        return packageRoot;
    }

    @Override
    public PackageRoot consumePackageRoot(PackageRoot packageRoot) throws IOException {
        PackageRoot existing = this.metadataStore.getPackageByName((NpmRepository)this.getNpmRepository(), packageRoot.getName());
        if (existing != null) {
            existing.overlay(packageRoot);
        } else {
            existing = packageRoot;
        }
        existing.maintainTime();
        return this.metadataStore.updatePackage((NpmRepository)this.getNpmRepository(), existing);
    }

    @Override
    @Nullable
    protected PackageRoot doGeneratePackageRoot(PackageRequest request) throws IOException {
        return this.metadataStore.getPackageByName((NpmRepository)this.getNpmRepository(), request.getName());
    }
}

