/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal;

import com.bolyuba.nexus.plugin.npm.NpmRepository;
import com.bolyuba.nexus.plugin.npm.group.NpmGroupRepository;
import com.bolyuba.nexus.plugin.npm.service.GroupMetadataService;
import com.bolyuba.nexus.plugin.npm.service.PackageRequest;
import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.bolyuba.nexus.plugin.npm.service.PackageVersion;
import com.bolyuba.nexus.plugin.npm.service.internal.GeneratorSupport;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataParser;
import com.bolyuba.nexus.plugin.npm.service.internal.PackageRootIterator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.util.AlphanumComparator;
import org.sonatype.nexus.util.SystemPropertiesHelper;

public class GroupMetadataServiceImpl
extends GeneratorSupport
implements GroupMetadataService {
    private final NpmGroupRepository npmGroupRepository;
    private final AlphanumComparator comparator;
    private boolean mergeMetadata = SystemPropertiesHelper.getBoolean((String)"nexus.npm.mergeGroupMetadata", (boolean)true);

    public GroupMetadataServiceImpl(NpmGroupRepository npmGroupRepository, MetadataParser metadataParser) {
        super(npmGroupRepository, metadataParser);
        this.npmGroupRepository = (NpmGroupRepository)Preconditions.checkNotNull((Object)npmGroupRepository);
        this.comparator = new AlphanumComparator();
    }

    @Override
    public boolean isMergeMetadata() {
        return this.mergeMetadata;
    }

    @Override
    public void setMergeMetadata(boolean mergeMetadata) {
        this.mergeMetadata = mergeMetadata;
    }

    @Override
    protected PackageRootIterator doGenerateRegistryRoot(PackageRequest request) throws IOException {
        List<NpmRepository> members = this.getMembers();
        ArrayList iterators = Lists.newArrayList();
        for (NpmRepository member : members) {
            iterators.add(member.getMetadataService().generateRegistryRoot(request));
        }
        return new AggregatedPackageRootIterator(iterators);
    }

    @Override
    @Nullable
    protected PackageRoot doGeneratePackageRoot(PackageRequest request) throws IOException {
        List<NpmRepository> members;
        List<NpmRepository> list = members = request.isScoped() && !this.npmGroupRepository.getId().equals(request.getScope()) ? this.getScopeMembers(request.getScope()) : this.getMembers();
        if (this.isMergeMetadata()) {
            PackageRoot root = null;
            String latestVersion = null;
            for (NpmRepository member : Lists.reverse(members)) {
                PackageRoot memberRoot = member.getMetadataService().generatePackageRoot(request);
                if (memberRoot == null) continue;
                if (root == null) {
                    root = new PackageRoot(this.npmGroupRepository.getId(), memberRoot.getRaw());
                    latestVersion = this.getDistTagsLatest(root);
                    continue;
                }
                String memberLatestVersion = this.getDistTagsLatest(memberRoot);
                root.overlayIgnoringOrigin(memberRoot);
                if (memberLatestVersion == null || latestVersion != null && this.comparator.compare(memberLatestVersion, latestVersion) <= 0) continue;
                latestVersion = memberLatestVersion;
            }
            if (latestVersion != null) {
                this.setDistTagsLatest(root, latestVersion);
            }
            return root;
        }
        for (NpmRepository member : members) {
            PackageRoot root = member.getMetadataService().generatePackageRoot(request);
            if (root == null) continue;
            return root;
        }
        return null;
    }

    @Nullable
    private String getDistTagsLatest(PackageRoot root) {
        Map distTags = (Map)root.getRaw().get("dist-tags");
        if (distTags == null) {
            return null;
        }
        return (String)distTags.get("latest");
    }

    private void setDistTagsLatest(PackageRoot root, String version) {
        Map distTags = (Map)root.getRaw().get("dist-tags");
        if (distTags == null) {
            distTags = Maps.newHashMap();
            root.getRaw().put("dist-tags", distTags);
        }
        distTags.put("latest", version);
    }

    @Override
    @Nullable
    protected PackageVersion doGeneratePackageVersion(PackageRequest request) throws IOException {
        List<NpmRepository> members = request.isScoped() && !this.npmGroupRepository.getId().equals(request.getScope()) ? this.getScopeMembers(request.getScope()) : this.getMembers();
        for (NpmRepository member : members) {
            PackageVersion version = member.getMetadataService().generatePackageVersion(request);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @Override
    protected void filterPackageVersionDist(PackageRequest packageRequest, PackageVersion packageVersion) {
        if (!packageRequest.isScoped()) {
            super.filterPackageVersionDist(packageRequest, packageVersion);
        }
    }

    private List<NpmRepository> getMembers() {
        List members = this.npmGroupRepository.getMemberRepositories();
        ArrayList npmMembers = Lists.newArrayList();
        for (Repository member : members) {
            NpmRepository npmMember = (NpmRepository)member.adaptToFacet(NpmRepository.class);
            if (npmMember == null) continue;
            npmMembers.add(npmMember);
        }
        return npmMembers;
    }

    private List<NpmRepository> getScopeMembers(String scope) {
        List members = this.npmGroupRepository.getMemberRepositories();
        ArrayList scopeMembers = Lists.newArrayList();
        for (Repository member : members) {
            NpmRepository npmMember = (NpmRepository)member.adaptToFacet(NpmRepository.class);
            if (npmMember == null || !member.getId().equals(scope)) continue;
            scopeMembers.add(npmMember);
        }
        return scopeMembers;
    }

    private static class AggregatedPackageRootIterator
    implements PackageRootIterator {
        private final List<PackageRootIterator> iterators;
        private final Iterator<PackageRootIterator> iteratorsIterator;
        private final HashSet<String> names;
        private PackageRootIterator currentIterator;
        private PackageRoot next;

        private AggregatedPackageRootIterator(List<PackageRootIterator> iterators) {
            this.iterators = iterators;
            this.iteratorsIterator = iterators.iterator();
            this.names = Sets.newHashSet();
            this.currentIterator = this.iteratorsIterator.hasNext() ? this.iteratorsIterator.next() : PackageRootIterator.EMPTY;
            this.next = this.getNext();
        }

        private PackageRoot getNext() {
            while (this.currentIterator != PackageRootIterator.EMPTY) {
                while (this.currentIterator.hasNext()) {
                    PackageRoot next = (PackageRoot)this.currentIterator.next();
                    if (!this.names.add(next.getName())) continue;
                    return next;
                }
                if (this.iteratorsIterator.hasNext()) {
                    this.currentIterator = this.iteratorsIterator.next();
                    continue;
                }
                this.currentIterator = PackageRootIterator.EMPTY;
            }
            return null;
        }

        @Override
        public void close() {
            for (PackageRootIterator iterator : this.iterators) {
                try {
                    iterator.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.next != null;
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        @Override
        public PackageRoot next() {
            PackageRoot result = this.next;
            if (result == null) {
                throw new NoSuchElementException("Iterator depleted");
            }
            this.next = this.getNext();
            if (this.next == null) {
                this.close();
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

