/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal;

import com.bolyuba.nexus.plugin.npm.NpmRepository;
import com.bolyuba.nexus.plugin.npm.service.PackageRequest;
import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.bolyuba.nexus.plugin.npm.service.internal.GeneratorSupport;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataParser;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataStore;
import com.bolyuba.nexus.plugin.npm.service.internal.PackageRootIterator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public abstract class GeneratorWithStoreSupport<R extends NpmRepository>
extends GeneratorSupport<R> {
    protected final MetadataStore metadataStore;

    protected GeneratorWithStoreSupport(R npmRepository, MetadataParser metadataParser, MetadataStore metadataStore) {
        super(npmRepository, metadataParser);
        this.metadataStore = (MetadataStore)Preconditions.checkNotNull((Object)metadataStore);
    }

    @Override
    protected PackageRootIterator doGenerateRegistryRoot(PackageRequest request) throws IOException {
        return new MetadataStorePackageRootIterator(this.metadataStore.listPackageNames((NpmRepository)this.getNpmRepository()));
    }

    protected class MetadataStorePackageRootIterator
    implements PackageRootIterator {
        private final Iterator<String> packageNames;

        protected MetadataStorePackageRootIterator(List<String> packageNames) {
            this.packageNames = packageNames.iterator();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean hasNext() {
            return this.packageNames.hasNext();
        }

        @Override
        public PackageRoot next() {
            PackageRoot root = GeneratorWithStoreSupport.this.metadataStore.getPackageByName((NpmRepository)GeneratorWithStoreSupport.this.getNpmRepository(), this.packageNames.next());
            if (root == null) {
                return null;
            }
            if (!root.isUnpublished()) {
                root.shrinkPackageVersions();
            }
            GeneratorWithStoreSupport.this.filterPackageRoot(root);
            return root;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported.");
        }
    }
}

