/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service.internal;

import com.bolyuba.nexus.plugin.npm.NpmRepository;
import com.bolyuba.nexus.plugin.npm.service.Generator;
import com.bolyuba.nexus.plugin.npm.service.PackageRequest;
import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.bolyuba.nexus.plugin.npm.service.PackageVersion;
import com.bolyuba.nexus.plugin.npm.service.internal.MetadataParser;
import com.bolyuba.nexus.plugin.npm.service.internal.PackageRootIterator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.web.BaseUrlHolder;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.common.SimpleFormat;

public abstract class GeneratorSupport<R extends NpmRepository>
extends ComponentSupport
implements Generator {
    private final R npmRepository;
    protected final MetadataParser metadataParser;

    protected GeneratorSupport(R npmRepository, MetadataParser metadataParser) {
        this.npmRepository = (NpmRepository)Preconditions.checkNotNull(npmRepository);
        this.metadataParser = (MetadataParser)((Object)Preconditions.checkNotNull((Object)((Object)metadataParser)));
    }

    protected R getNpmRepository() {
        return this.npmRepository;
    }

    @Override
    public boolean isNpmMetadataServiced(ResourceStoreRequest request) {
        return !"/".equals(request.getRequestPath()) && (!request.isExternal() || !request.getRequestUrl().contains("/service/local/") || !request.getRequestUrl().contains("/content/")) && !request.getRequestContext().containsKey((Object)"NpmMetadataNoService", false);
    }

    @Override
    public ContentLocator produceRegistryRoot(PackageRequest request) throws IOException {
        return this.metadataParser.produceRegistryRoot(this.generateRegistryRoot(request));
    }

    @Override
    @Nullable
    public ContentLocator producePackageRoot(PackageRequest request) throws IOException {
        PackageRoot root = this.generatePackageRoot(request);
        if (root == null) {
            return null;
        }
        this.filterPackageRoot(root);
        return this.metadataParser.producePackageRoot(root);
    }

    @Override
    @Nullable
    public ContentLocator producePackageVersion(PackageRequest request) throws IOException {
        PackageVersion version = this.generatePackageVersion(request);
        if (version == null || version.isIncomplete()) {
            return null;
        }
        this.filterPackageVersion(version);
        return this.metadataParser.producePackageVersion(version);
    }

    @Override
    public PackageRootIterator generateRegistryRoot(PackageRequest request) throws IOException {
        return this.doGenerateRegistryRoot(request);
    }

    protected abstract PackageRootIterator doGenerateRegistryRoot(PackageRequest var1) throws IOException;

    @Override
    @Nullable
    public PackageRoot generatePackageRoot(PackageRequest request) throws IOException {
        Preconditions.checkArgument((boolean)request.isPackageRoot(), (String)"Package root request expected, but got %s", (Object[])new Object[]{request.getPath()});
        PackageRoot root = this.doGeneratePackageRoot(request);
        if (root == null) {
            return null;
        }
        this.filterPackageRootDist(request, root);
        return root;
    }

    @Nullable
    protected abstract PackageRoot doGeneratePackageRoot(PackageRequest var1) throws IOException;

    @Override
    @Nullable
    public PackageVersion generatePackageVersion(PackageRequest request) throws IOException {
        Preconditions.checkArgument((boolean)request.isPackageVersion(), (String)"Package version request expected, but got %s", (Object[])new Object[]{request.getPath()});
        PackageVersion version = this.doGeneratePackageVersion(request);
        if (version == null) {
            return null;
        }
        this.filterPackageVersionDist(request, version);
        return version;
    }

    @Nullable
    protected PackageVersion doGeneratePackageVersion(PackageRequest request) throws IOException {
        Preconditions.checkArgument((boolean)request.isPackageVersion(), (String)"Package version request expected, but got %s", (Object[])new Object[]{request.getPath()});
        PackageRoot root = this.doGeneratePackageRoot(request);
        if (root == null || root.isUnpublished()) {
            return null;
        }
        PackageVersion version = root.getVersions().get(request.getVersion());
        if (version == null || version.isIncomplete()) {
            return null;
        }
        return version;
    }

    protected void filterPackageRoot(PackageRoot packageRoot) {
        packageRoot.getRaw().remove("_id");
        packageRoot.getRaw().remove("_rev");
        for (PackageVersion packageVersion : packageRoot.getVersions().values()) {
            this.filterPackageVersion(packageVersion);
        }
    }

    protected void filterPackageVersion(PackageVersion packageVersion) {
        packageVersion.getRaw().remove("_id");
        packageVersion.getRaw().remove("_rev");
    }

    protected void filterPackageRootDist(PackageRequest packageRequest, PackageRoot packageRoot) {
        for (PackageVersion packageVersion : packageRoot.getVersions().values()) {
            this.filterPackageVersionDist(packageRequest, packageVersion);
        }
    }

    protected void filterPackageVersionDist(PackageRequest packageRequest, PackageVersion packageVersion) {
        if (this.npmRepository.adaptToFacet(GroupRepository.class) != null) {
            packageVersion.setDistTarball(SimpleFormat.format((String)"%s/content/groups/%s/%s/-/%s", (Object[])new Object[]{BaseUrlHolder.get(), this.npmRepository.getId(), packageVersion.getName(), packageVersion.getDistTarballFilename()}));
        } else {
            packageVersion.setDistTarball(SimpleFormat.format((String)"%s/content/repositories/%s/%s/-/%s", (Object[])new Object[]{BaseUrlHolder.get(), this.npmRepository.getId(), packageVersion.getName(), packageVersion.getDistTarballFilename()}));
        }
        String versionTarballShasum = PackageVersion.createShasumVersionKey(packageVersion.getVersion());
        if (packageVersion.getRoot().getProperties().containsKey(versionTarballShasum)) {
            packageVersion.setDistShasum(packageVersion.getRoot().getProperties().get(versionTarballShasum));
        }
    }
}

