/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service;

import com.bolyuba.nexus.plugin.npm.service.NpmJson;
import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import javax.annotation.Nullable;

public class PackageVersion
extends NpmJson {
    public static final String TARBALL_NX_SHASUM = "nx.shasum";
    private final PackageRoot root;

    public static String createShasumVersionKey(String version) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)version) ? 1 : 0) != 0, (Object)"Version cannot be null or empty");
        return "nx.shasum@" + version;
    }

    public PackageVersion(PackageRoot root, String repositoryId, Map<String, Object> raw) {
        super(repositoryId, raw);
        this.root = (PackageRoot)Preconditions.checkNotNull((Object)root);
    }

    public PackageRoot getRoot() {
        return this.root;
    }

    public String getName() {
        return (String)this.getRaw().get("name");
    }

    public String getDescription() {
        return (String)this.getRaw().get("description");
    }

    public String getVersion() {
        return (String)this.getRaw().get("version");
    }

    public String getDistTarball() {
        return (String)((Map)this.getRaw().get("dist")).get("tarball");
    }

    @Nullable
    public String getDistShasum() {
        return (String)((Map)this.getRaw().get("dist")).get("shasum");
    }

    public String getDistTarballFilename() {
        String tarballUrl = this.getDistTarball();
        int idx = tarballUrl.lastIndexOf("/");
        if (idx != -1) {
            return tarballUrl.substring(idx + 1);
        }
        return this.getName() + "-" + this.getVersion() + ".tgz";
    }

    public void setDistTarball(String tarball) {
        Preconditions.checkNotNull((Object)tarball);
        ((Map)this.getRaw().get("dist")).put("tarball", tarball);
    }

    public void setDistShasum(String shasum) {
        Preconditions.checkNotNull((Object)shasum);
        ((Map)this.getRaw().get("dist")).put("shasum", shasum);
    }

    public boolean isIncomplete() {
        return "unknown".equals(this.getDistTarball());
    }

    @Override
    protected void validate(Map<String, Object> raw) {
        Preconditions.checkNotNull(raw);
        Preconditions.checkArgument((boolean)raw.containsKey("name"), (Object)"No mapping for 'name'");
        Preconditions.checkArgument((boolean)(raw.get("name") instanceof String), (Object)"Mapping for 'name' is not a string");
        Preconditions.checkArgument((boolean)raw.containsKey("version"), (Object)"No mapping for 'version'");
        Preconditions.checkArgument((boolean)(raw.get("version") instanceof String), (Object)"Mapping for 'version' is not a string");
        Preconditions.checkArgument((boolean)raw.containsKey("dist"), (Object)"No mapping for 'dist'");
        Preconditions.checkArgument((boolean)(raw.get("dist") instanceof Map), (Object)"'dist' is not an object hash");
        Preconditions.checkArgument((boolean)((Map)raw.get("dist")).containsKey("tarball"), (Object)"No mapping for 'dist.tarball'");
        Preconditions.checkArgument((boolean)(((Map)raw.get("dist")).get("tarball") instanceof String), (Object)"Mapping for 'dist.tarball' is not a string");
    }
}

