/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service;

import com.bolyuba.nexus.plugin.npm.service.NpmBlob;
import com.bolyuba.nexus.plugin.npm.service.NpmJson;
import com.bolyuba.nexus.plugin.npm.service.PackageVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class PackageRoot
extends NpmJson {
    public static final String PROP_CACHED = "remote.cached";
    public static final String PROP_EXPIRED = "remote.expired";
    public static final String PROP_ETAG = "remote.etag";
    private final Map<String, String> properties = Maps.newHashMap();
    private final Map<String, PackageVersion> wrappedVersions = Maps.newHashMap();
    private final Map<String, NpmBlob> attachments;

    public PackageRoot(String repositoryId, Map<String, Object> raw) {
        super(repositoryId, raw);
        this.wrappedVersions.putAll(this.wrapVersions(raw));
        this.attachments = Maps.newHashMap();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getComponentId() {
        return this.getRepositoryId() + ":" + this.getName();
    }

    public String getName() {
        return (String)this.getRaw().get("name");
    }

    public String getDescription() {
        return (String)this.getRaw().get("description");
    }

    public Map<String, PackageVersion> getVersions() {
        return this.wrappedVersions;
    }

    public Map<String, NpmBlob> getAttachments() {
        return this.attachments;
    }

    public void maintainTime() {
        if (!this.getRaw().containsKey("time")) {
            this.getRaw().put("time", Maps.newHashMap());
        }
        Map time = (Map)this.getRaw().get("time");
        String now = new DateTime(DateTimeZone.UTC).toString();
        if (!time.containsKey("created")) {
            time.put("created", now);
        }
        time.put("modified", now);
        for (String version : this.wrappedVersions.keySet()) {
            if (time.containsKey(version)) continue;
            time.put(version, now);
        }
    }

    public void shrinkPackageVersions() {
        if (this.isUnpublished()) {
            return;
        }
        HashMap shrinkedVersions = Maps.newHashMap();
        for (Map.Entry<String, PackageVersion> version : this.wrappedVersions.entrySet()) {
            shrinkedVersions.put(version.getKey(), this.resolveVersionToTag(version.getKey()));
        }
        ((Map)this.getRaw().get("versions")).clear();
        ((Map)this.getRaw().get("versions")).putAll(shrinkedVersions);
        this.wrappedVersions.clear();
    }

    public boolean isUnpublished() {
        return this.wrappedVersions.isEmpty();
    }

    public boolean isIncomplete() {
        if (this.isUnpublished()) {
            return false;
        }
        for (PackageVersion pv : this.getVersions().values()) {
            if (!pv.isIncomplete()) continue;
            return true;
        }
        return false;
    }

    public void overlay(PackageRoot packageRoot) {
        Preconditions.checkArgument((boolean)this.getComponentId().equals(packageRoot.getComponentId()), (Object)"Cannot overlay different package roots!");
        this.overlayIgnoringOrigin(packageRoot);
    }

    public void overlayIgnoringOrigin(PackageRoot packageRoot) {
        this.overlay(this.getRaw(), packageRoot.getRaw());
        this.getProperties().putAll(packageRoot.getProperties());
        this.wrappedVersions.clear();
        this.wrappedVersions.putAll(this.wrapVersions(this.getRaw()));
        this.attachments.clear();
        this.attachments.putAll(packageRoot.getAttachments());
    }

    private Map<String, Object> overlay(Map<String, Object> me, Map<String, Object> him) {
        for (String key : him.keySet()) {
            if (him.get(key) instanceof Map && me.get(key) instanceof Map) {
                Map myChild = (Map)me.get(key);
                Map hisChild = (Map)him.get(key);
                me.put(key, this.overlay(myChild, hisChild));
                continue;
            }
            if (him.get(key) instanceof String && me.get(key) instanceof Map) continue;
            me.put(key, him.get(key));
        }
        return me;
    }

    @Override
    protected void validate(Map<String, Object> raw) {
        Preconditions.checkNotNull(raw);
        Preconditions.checkArgument((boolean)raw.containsKey("name"), (Object)"No mapping for 'name'");
        Preconditions.checkArgument((boolean)(raw.get("name") instanceof String), (Object)"Mapping for 'name' is not a string");
        if (raw.containsKey("versions")) {
            Preconditions.checkArgument((boolean)raw.containsKey("versions"), (Object)"No mapping for 'versions'");
            Preconditions.checkArgument((boolean)(raw.get("versions") instanceof Map), (Object)"'versions' is not an object hash");
        }
    }

    private Map<String, PackageVersion> wrapVersions(Map<String, Object> raw) {
        HashMap wrappedVersions = Maps.newHashMap();
        Map versions = (Map)raw.get("versions");
        if (versions != null) {
            for (Map.Entry versionsEntry : versions.entrySet()) {
                if (versionsEntry.getValue() instanceof Map) {
                    wrappedVersions.put(versionsEntry.getKey(), new PackageVersion(this, this.getRepositoryId(), (Map)versionsEntry.getValue()));
                    continue;
                }
                if (!(versionsEntry.getValue() instanceof String)) continue;
                HashMap latestVersion = Maps.newHashMap();
                latestVersion.put("name", raw.get("name"));
                if (raw.containsKey("description")) {
                    latestVersion.put("description", raw.get("description"));
                }
                latestVersion.put("version", versionsEntry.getKey());
                HashMap dist = Maps.newHashMap();
                dist.put("tarball", "unknown");
                latestVersion.put("dist", dist);
                wrappedVersions.put(versionsEntry.getKey(), new PackageVersion(this, this.getRepositoryId(), latestVersion));
            }
        }
        return wrappedVersions;
    }

    private String resolveVersionToTag(String version) {
        if (this.getRaw().containsKey("dist-tags")) {
            Map distTags = (Map)this.getRaw().get("dist-tags");
            for (Map.Entry distTag : distTags.entrySet()) {
                if (!version.equals(distTag.getValue())) continue;
                return (String)distTag.getKey();
            }
        }
        return version;
    }
}

