/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import org.sonatype.nexus.proxy.ResourceStoreRequest;

public class PackageRequest {
    private final ResourceStoreRequest storeRequest;
    private final PackageCoordinates coordinates;

    public PackageRequest(@Nonnull ResourceStoreRequest storeRequest) throws IllegalArgumentException {
        this.storeRequest = (ResourceStoreRequest)Preconditions.checkNotNull((Object)storeRequest);
        this.coordinates = PackageCoordinates.coordinatesFromUrl(storeRequest.getRequestPath());
    }

    public ResourceStoreRequest getStoreRequest() {
        return this.storeRequest;
    }

    public boolean isRegistryRoot() {
        return PackageCoordinates.Type.REGISTRY_ROOT == this.coordinates.getType();
    }

    public boolean isPackageRoot() {
        return PackageCoordinates.Type.PACKAGE_ROOT == this.coordinates.getType();
    }

    public boolean isPackageVersion() {
        return PackageCoordinates.Type.PACKAGE_VERSION == this.coordinates.getType();
    }

    public boolean isRegistrySpecial() {
        return PackageCoordinates.Type.REGISTRY_SPECIAL == this.coordinates.getType();
    }

    public boolean isPackage() {
        return this.isPackageRoot() || this.isPackageVersion();
    }

    public boolean isMetadata() {
        return this.isRegistryRoot() || this.isPackageRoot() || this.isPackageVersion();
    }

    public boolean isScoped() {
        return !Strings.isNullOrEmpty((String)this.coordinates.getScope());
    }

    public String getPath() {
        return this.coordinates.getPath();
    }

    public String getScope() {
        return this.coordinates.getScope();
    }

    public String getName() {
        return this.coordinates.getPackageName();
    }

    public String getVersion() {
        return this.coordinates.getPackageVersion();
    }

    public String toString() {
        return "PackageRequest{storeRequest=" + this.storeRequest + ", coordinates=" + this.coordinates + '}';
    }

    static class PackageCoordinates {
        private Type type;
        private String scope;
        private String packageName;
        private String packageVersion;
        private String path;

        private PackageCoordinates() {
        }

        public String getName() {
            if (Strings.isNullOrEmpty((String)this.getScope())) {
                return this.getPackageName();
            }
            return "@" + this.getScope() + "/" + this.getPackageName();
        }

        public String getScope() {
            return this.scope;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getPackageVersion() {
            return this.packageVersion;
        }

        public String getPath() {
            return this.path;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return "PackageCoordinates{type=" + (Object)((Object)this.type) + ", scope='" + this.scope + '\'' + ", packageName='" + this.packageName + '\'' + ", packageVersion='" + this.packageVersion + '\'' + ", path='" + this.path + '\'' + '}';
        }

        public static PackageCoordinates coordinatesFromUrl(@Nonnull String requestPath) throws IllegalArgumentException {
            PackageCoordinates coordinates = new PackageCoordinates();
            coordinates.path = requestPath;
            if ("/".equals(requestPath)) {
                coordinates.type = Type.REGISTRY_ROOT;
                return coordinates;
            }
            if (requestPath.startsWith("/-/")) {
                coordinates.type = Type.REGISTRY_SPECIAL;
                return coordinates;
            }
            String correctedPath = requestPath.startsWith("/") ? requestPath.substring(1, requestPath.length()) : requestPath;
            String[] explodedPath = correctedPath.split("/");
            if (explodedPath.length == 2) {
                if (explodedPath[0].startsWith("@")) {
                    coordinates.type = Type.PACKAGE_ROOT;
                    coordinates.scope = PackageCoordinates.validate(explodedPath[0].substring(1), "Invalid package scope: ");
                    coordinates.packageName = "@" + coordinates.scope + "/" + PackageCoordinates.validate(explodedPath[1], "Invalid package name: ");
                    return coordinates;
                }
                coordinates.type = Type.PACKAGE_VERSION;
                coordinates.packageName = PackageCoordinates.validate(explodedPath[0], "Invalid package name: ");
                coordinates.packageVersion = PackageCoordinates.validate(explodedPath[1], "Invalid package version: ");
                return coordinates;
            }
            if (explodedPath.length == 1) {
                coordinates.type = Type.PACKAGE_ROOT;
                coordinates.packageName = PackageCoordinates.validate(explodedPath[0], "Invalid package name: ");
                return coordinates;
            }
            throw new IllegalArgumentException("Path " + requestPath + " cannot be turned into PackageCoordinates");
        }

        private static String validate(@Nonnull String nameOrVersion, String errorPrefix) throws IllegalArgumentException {
            if (nameOrVersion.startsWith("-")) {
                throw new IllegalArgumentException(errorPrefix + nameOrVersion);
            }
            if (nameOrVersion.equals(".")) {
                throw new IllegalArgumentException(errorPrefix + nameOrVersion);
            }
            if (nameOrVersion.equals("..")) {
                throw new IllegalArgumentException(errorPrefix + nameOrVersion);
            }
            return nameOrVersion;
        }

        static enum Type {
            REGISTRY_ROOT,
            PACKAGE_ROOT,
            PACKAGE_VERSION,
            REGISTRY_SPECIAL;

        }
    }
}

