/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.proxy;

import com.bolyuba.nexus.plugin.npm.internal.NpmMimeRulesSource;
import com.bolyuba.nexus.plugin.npm.proxy.NpmProxyRepository;
import com.bolyuba.nexus.plugin.npm.proxy.NpmProxyRepositoryConfiguration;
import com.bolyuba.nexus.plugin.npm.proxy.NpmProxyRepositoryConfigurator;
import com.bolyuba.nexus.plugin.npm.service.MetadataServiceFactory;
import com.bolyuba.nexus.plugin.npm.service.NpmBlob;
import com.bolyuba.nexus.plugin.npm.service.PackageRequest;
import com.bolyuba.nexus.plugin.npm.service.PackageVersion;
import com.bolyuba.nexus.plugin.npm.service.ProxyMetadataService;
import com.bolyuba.nexus.plugin.npm.service.tarball.TarballRequest;
import com.bolyuba.nexus.plugin.npm.service.tarball.TarballSource;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.sisu.Description;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.RemoteAccessException;
import org.sonatype.nexus.proxy.RemoteStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.AbstractProxyRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.walker.WalkerFilter;

@Named(value="npm-proxy")
@Typed(value={Repository.class})
@Description(value="Npm registry proxy repo")
public class DefaultNpmProxyRepository
extends AbstractProxyRepository
implements NpmProxyRepository,
Repository {
    public static final String ROLE_HINT = "npm-proxy";
    private static final String TARBALL_REQUEST = "npm.tarballRequest";
    private final ContentClass contentClass;
    private final NpmProxyRepositoryConfigurator configurator;
    private final RepositoryKind repositoryKind;
    private final NpmMimeRulesSource mimeRulesSource;
    private final ProxyMetadataService proxyMetadataService;
    private final TarballSource tarballSource;

    @Inject
    public DefaultNpmProxyRepository(@Named(value="npm") ContentClass contentClass, NpmProxyRepositoryConfigurator configurator, MetadataServiceFactory metadataServiceFactory, TarballSource tarballSource) {
        this.proxyMetadataService = metadataServiceFactory.createProxyMetadataService(this);
        this.tarballSource = (TarballSource)Preconditions.checkNotNull((Object)tarballSource);
        this.contentClass = (ContentClass)Preconditions.checkNotNull((Object)contentClass);
        this.configurator = (NpmProxyRepositoryConfigurator)((Object)Preconditions.checkNotNull((Object)((Object)configurator)));
        this.repositoryKind = new DefaultRepositoryKind(NpmProxyRepository.class, null);
        this.mimeRulesSource = new NpmMimeRulesSource();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onEvent(RepositoryRegistryEventRemove event) {
        if (event.getRepository() == this) {
            this.getMetadataService().deleteAllMetadata();
        }
    }

    @Override
    public ProxyMetadataService getMetadataService() {
        return this.proxyMetadataService;
    }

    protected Configurator getConfigurator() {
        return this.configurator;
    }

    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    protected CRepositoryExternalConfigurationHolderFactory<NpmProxyRepositoryConfiguration> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<NpmProxyRepositoryConfiguration>(){

            public NpmProxyRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new NpmProxyRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    public MimeRulesSource getMimeRulesSource() {
        return this.mimeRulesSource;
    }

    protected boolean doExpireProxyCaches(ResourceStoreRequest request, WalkerFilter filter) {
        request.getRequestContext().put("NpmMetadataNoService", (Object)Boolean.TRUE);
        boolean result = super.doExpireProxyCaches(request, filter);
        try {
            boolean npmResult = this.proxyMetadataService.expireMetadataCaches(new PackageRequest(request));
            return result || npmResult;
        }
        catch (IllegalArgumentException ignore) {
            return result;
        }
    }

    protected AbstractStorageItem doRetrieveLocalItem(ResourceStoreRequest storeRequest) throws ItemNotFoundException, LocalStorageException {
        try {
            if (!this.getMetadataService().isNpmMetadataServiced(storeRequest)) {
                return this.delegateDoRetrieveLocalItem(storeRequest);
            }
            PackageRequest packageRequest = null;
            try {
                packageRequest = new PackageRequest(storeRequest);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (packageRequest != null) {
                packageRequest.getStoreRequest().getRequestContext().put("NpmMetadataServiced", (Object)Boolean.TRUE);
                if (packageRequest.isMetadata()) {
                    ContentLocator contentLocator;
                    if (packageRequest.isRegistryRoot()) {
                        this.log.debug("Serving registry root...");
                        contentLocator = this.proxyMetadataService.produceRegistryRoot(packageRequest);
                    } else if (packageRequest.isPackageRoot()) {
                        this.log.debug("Serving package {} root...", (Object)packageRequest.getName());
                        contentLocator = this.proxyMetadataService.producePackageRoot(packageRequest);
                    } else {
                        this.log.debug("Serving package {} version {}...", (Object)packageRequest.getName(), (Object)packageRequest.getVersion());
                        contentLocator = this.proxyMetadataService.producePackageVersion(packageRequest);
                    }
                    if (contentLocator == null) {
                        this.log.debug("No NPM metadata for path {}", (Object)storeRequest.getRequestPath());
                        throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)storeRequest, (Repository)this, (String)"No content for path %s", (Object[])new Object[]{storeRequest.getRequestPath()}));
                    }
                    return this.createStorageFileItem(storeRequest, contentLocator);
                }
                if (packageRequest.isRegistrySpecial() && packageRequest.getPath().startsWith("/-/all")) {
                    this.log.debug("Serving registry root from /-/all...");
                    return this.createStorageFileItem(storeRequest, this.proxyMetadataService.produceRegistryRoot(packageRequest));
                }
                this.log.debug("Unknown registry special {}", (Object)packageRequest.getPath());
                throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)storeRequest, (Repository)this, (String)"No content for path %s", (Object[])new Object[]{storeRequest.getRequestPath()}));
            }
            TarballRequest tarballRequest = this.getMetadataService().createTarballRequest(storeRequest);
            if (tarballRequest != null) {
                storeRequest.getRequestContext().put(TARBALL_REQUEST, (Object)tarballRequest);
                try {
                    PackageVersion version;
                    AbstractStorageItem item = this.delegateDoRetrieveLocalItem(storeRequest);
                    if (item instanceof StorageFileItem && !Strings.isNullOrEmpty((String)(version = tarballRequest.getPackageVersion()).getDistShasum()) && version.getDistShasum().equals(item.getRepositoryItemAttributes().get("nx.shasum"))) {
                        item.setRemoteChecked(Long.MAX_VALUE);
                        item.setExpired(false);
                        return item;
                    }
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
            throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)storeRequest, (Repository)this, (String)"No local content for path %s", (Object[])new Object[]{storeRequest.getRequestPath()}));
        }
        catch (IOException e) {
            throw new LocalStorageException("Metadata service error", (Throwable)e);
        }
    }

    @VisibleForTesting
    DefaultStorageFileItem createStorageFileItem(ResourceStoreRequest storeRequest, ContentLocator contentLocator) {
        DefaultStorageFileItem result = new DefaultStorageFileItem((Repository)this, storeRequest, true, true, contentLocator);
        result.setRemoteChecked(Long.MAX_VALUE);
        result.setExpired(false);
        result.getItemContext().put("NpmMetadataServiced", (Object)Boolean.TRUE);
        return result;
    }

    protected void shouldTryRemote(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException {
        super.shouldTryRemote(request);
        if (request.getRequestContext().containsKey((Object)"NpmMetadataServiced")) {
            throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)request, (Repository)this, (String)"Request is serviced by NPM metadata service, remote access not needed from %s", (Object[])new Object[]{this}));
        }
    }

    protected boolean shouldAddToNotFoundCache(ResourceStoreRequest request) {
        boolean shouldAddToNFC = super.shouldAddToNotFoundCache(request);
        if (shouldAddToNFC) {
            return !request.getRequestContext().containsKey((Object)"NpmMetadataServiced");
        }
        return shouldAddToNFC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractStorageItem doCacheItem(AbstractStorageItem item) throws LocalStorageException {
        NpmBlob tarball = null;
        if (item instanceof StorageFileItem && ((StorageFileItem)item).getContentLocator() instanceof NpmBlob) {
            tarball = (NpmBlob)((StorageFileItem)item).getContentLocator();
        }
        try {
            ResourceStoreRequest storeRequest = item.getResourceStoreRequest();
            PackageRequest packageRequest = new PackageRequest(storeRequest);
            this.log.info("NPM cache {}", (Object)packageRequest.getPath());
            if (packageRequest.isMetadata()) {
                AbstractStorageItem abstractStorageItem = item;
                return abstractStorageItem;
            }
            AbstractStorageItem abstractStorageItem = this.delegateDoCacheItem(item);
            return abstractStorageItem;
        }
        catch (IllegalArgumentException ignore) {
            AbstractStorageItem abstractStorageItem = this.delegateDoCacheItem(item);
            return abstractStorageItem;
        }
        finally {
            if (tarball != null) {
                try {
                    tarball.delete();
                }
                catch (IOException e) {
                    this.log.warn("Cannot delete temporary file: " + tarball.getFile().getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }

    AbstractStorageItem delegateDoCacheItem(AbstractStorageItem item) throws LocalStorageException {
        return super.doCacheItem(item);
    }

    AbstractStorageItem delegateDoRetrieveLocalItem(ResourceStoreRequest storeRequest) throws LocalStorageException, ItemNotFoundException {
        return super.doRetrieveLocalItem(storeRequest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractStorageItem doRetrieveRemoteItem(ResourceStoreRequest request) throws ItemNotFoundException, RemoteAccessException, StorageException {
        if (request.getRequestContext().containsKey((Object)"NpmMetadataNoService", false)) {
            throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)request, (Repository)this, (String)"Request shut down NPM proxy for %s", (Object[])new Object[]{this}));
        }
        RepositoryItemUid itemUid = this.createUid(request.getRequestPath());
        RepositoryItemUidLock itemUidLock = itemUid.getLock();
        itemUidLock.lock(Action.create);
        try {
            TarballRequest tarballRequest = (TarballRequest)request.getRequestContext().get((Object)TARBALL_REQUEST, false);
            if (tarballRequest == null) throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)request, (Repository)this, (String)"Request cannot be serviced by NPM proxy %s: tarball package not found", (Object[])new Object[]{this}));
            NpmBlob tarball = this.tarballSource.get(this, tarballRequest);
            if (tarball != null) {
                tarballRequest.getPackageRoot().getProperties().put(PackageVersion.createShasumVersionKey(tarballRequest.getPackageVersion().getVersion()), tarball.getSha1sum());
                this.getMetadataService().consumeRawPackageRoot(tarballRequest.getPackageRoot());
                DefaultStorageFileItem result = new DefaultStorageFileItem((Repository)this, request, true, true, (ContentLocator)tarball);
                result.getRepositoryItemAttributes().put("nx.shasum", tarball.getSha1sum());
                AbstractStorageItem abstractStorageItem = this.doCacheItem((AbstractStorageItem)result);
                return abstractStorageItem;
            }
            try {
                throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)request, (Repository)this, (String)"Request cannot be serviced by NPM proxy %s: tarball for package %s version %s not found on remote", (Object[])new Object[]{this, tarballRequest.getPackageVersion().getName(), tarballRequest.getPackageVersion().getVersion()}));
            }
            catch (IOException e) {
                throw new RemoteStorageException("NPM service error", (Throwable)e);
            }
        }
        finally {
            itemUidLock.unlock();
        }
    }

    public void deleteItem(boolean fromTask, ResourceStoreRequest storeRequest) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException {
        block8: {
            PackageRequest packageRequest = null;
            try {
                packageRequest = new PackageRequest(storeRequest);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            boolean supressItemNotFound = false;
            if (packageRequest != null && packageRequest.isMetadata()) {
                if (packageRequest.isRegistryRoot()) {
                    this.log.debug("Deleting registry root...");
                    this.getMetadataService().deleteAllMetadata();
                } else if (packageRequest.isPackageRoot()) {
                    this.log.debug("Deleting package {} root...", (Object)packageRequest.getName());
                    supressItemNotFound = this.getMetadataService().deletePackage(packageRequest.getName());
                }
            }
            try {
                super.deleteItem(fromTask, storeRequest);
            }
            catch (ItemNotFoundException e) {
                if (supressItemNotFound) break block8;
                throw e;
            }
        }
    }

    protected boolean isOld(int maxAge, StorageItem item, boolean shouldCalculate) {
        if (item.getItemContext().containsKey((Object)"NpmMetadataServiced")) {
            return false;
        }
        return super.isOld(maxAge, item, shouldCalculate);
    }
}

