/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.hosted;

import com.bolyuba.nexus.plugin.npm.service.HostedMetadataService;
import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.walker.AbstractWalkerProcessor;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.util.AlphanumComparator;
import org.sonatype.nexus.util.io.StreamSupport;
import org.sonatype.sisu.goodies.common.Iso8601Date;

public class RecreateMetadataWalkerProcessor
extends AbstractWalkerProcessor {
    private static final String PACKAGE_JSON_PATH = "/package.json";
    private static final int MAX_PACKAGE_JSON_FILE_SIZE = 1000000;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HostedMetadataService hostedMetadataService;
    private int packageRoots;
    private int packageVersions;

    public RecreateMetadataWalkerProcessor(HostedMetadataService hostedMetadataService) {
        this.hostedMetadataService = hostedMetadataService;
        this.packageRoots = 0;
        this.packageVersions = 0;
    }

    public int getPackageRoots() {
        return this.packageRoots;
    }

    public int getPackageVersions() {
        return this.packageVersions;
    }

    public void processItem(WalkerContext context, StorageItem item) throws Exception {
    }

    public void onCollectionExit(WalkerContext context, StorageCollectionItem coll) throws Exception {
        TreeMap versions = Maps.newTreeMap((Comparator)new AlphanumComparator());
        Collection items = coll.list();
        for (Object item : items) {
            if (!(item instanceof StorageFileItem) || !item.getName().endsWith(".tgz")) continue;
            try {
                StorageFileItem file = (StorageFileItem)item;
                Map<String, Object> versionJson = this.extractPackageJson(file);
                if (!versionJson.containsKey("name") || !versionJson.containsKey("version")) {
                    this.log.info("Malformed package.json in {}", (Object)file.getRepositoryItemUid());
                    continue;
                }
                String version = String.valueOf(versionJson.get("version"));
                HashMap dist = Maps.newHashMap();
                dist.put("tarball", "generated-on-request");
                dist.put("shasum", file.getRepositoryItemAttributes().get("digest.sha1"));
                versionJson.put("dist", dist);
                versions.put(version, versionJson);
            }
            catch (Exception e) {
                this.log.info("Failed to extract or malformed package.json from {}", (Object)item.getRepositoryItemUid(), (Object)e);
            }
        }
        if (versions.isEmpty()) {
            return;
        }
        HashMap rootJson = Maps.newHashMap();
        rootJson.put("dist-tags", Maps.newHashMap());
        rootJson.put("versions", Maps.newHashMap());
        rootJson.put("x-nx-rebuilt", Iso8601Date.format((Date)new Date()));
        for (String version : versions.keySet()) {
            try {
                this.processPackageJson(rootJson, (Map)versions.get(version));
            }
            catch (IllegalArgumentException e) {
                this.log.info("Failed to process package.json from {} version {}", new Object[]{coll.getPath(), version, e});
            }
        }
        if (((Map)rootJson.get("versions")).isEmpty()) {
            return;
        }
        Map lastPackage = (Map)versions.get(versions.lastKey());
        String lastVersion = String.valueOf(lastPackage.get("version"));
        Map distTags = (Map)rootJson.get("dist-tags");
        distTags.remove(lastVersion);
        distTags.put("latest", lastVersion);
        PackageRoot packageRoot = new PackageRoot(context.getRepository().getId(), rootJson);
        this.hostedMetadataService.consumePackageRoot(packageRoot);
        ++this.packageRoots;
        this.packageVersions += versions.size();
    }

    private Map<String, Object> extractPackageJson(StorageFileItem file) throws IOException {
        Throwable throwable = null;
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(file.getInputStream());){
            TarArchiveEntry tarEntry;
            String tarEntryName;
            this.log.debug("Examining TAR file");
            TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)gzipInputStream);
            do {
                tarEntry = tarArchiveInputStream.getNextTarEntry();
                tarEntryName = null;
                if (tarEntry == null) continue;
                int indexOfSlash = tarEntry.getName().indexOf("/");
                if (indexOfSlash > 0) {
                    tarEntryName = tarEntry.getName().substring(indexOfSlash);
                }
                this.log.debug("tarEntry={}, name={}", (Object)tarEntry.getName(), (Object)tarEntryName);
            } while (tarEntryName != null && !PACKAGE_JSON_PATH.equalsIgnoreCase(tarEntryName));
            Preconditions.checkArgument((tarEntryName != null ? 1 : 0) != 0, (String)"Tar does not contains %s?", (Object[])new Object[]{PACKAGE_JSON_PATH});
            Preconditions.checkArgument((boolean)tarEntry.isFile(), (String)"Tar content %s not a file?", (Object[])new Object[]{PACKAGE_JSON_PATH});
            Preconditions.checkArgument((tarEntry.getSize() < 1000000L ? 1 : 0) != 0, (String)"Tar content too big %s: %s bytes", (Object[])new Object[]{PACKAGE_JSON_PATH, tarEntry.getSize()});
            ByteArrayOutputStream bos = new ByteArrayOutputStream(Ints.checkedCast((long)tarEntry.getSize()));
            StreamSupport.copy((InputStream)tarArchiveInputStream, (OutputStream)bos, (int)StreamSupport.BUFFER_SIZE);
            try {
                Map map = (Map)this.objectMapper.readValue(bos.toByteArray(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                return map;
            }
            catch (JsonParseException e) {
                block20: {
                    Map map;
                    block21: {
                        block22: {
                            if (!e.getMessage().contains("Invalid UTF-8 middle byte")) break block20;
                            this.log.debug("Tarball {} contains non-UTF package.json, parsing as ISO-8859-1: {}", (Object)file.getRepositoryItemUid(), (Object)e.getMessage());
                            map = (Map)this.objectMapper.readValue(new String(bos.toByteArray(), Charsets.ISO_8859_1), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                            if (gzipInputStream == null) break block21;
                            if (throwable == null) break block22;
                            try {
                                gzipInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block21;
                        }
                        gzipInputStream.close();
                    }
                    return map;
                }
                try {
                    throw e;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }

    private void processPackageJson(Map<String, Object> rootJson, Map<String, Object> packageJson) throws Exception {
        this.copyAttributes(rootJson, packageJson);
        String version = String.valueOf(packageJson.get("version"));
        Map distTags = (Map)rootJson.get("dist-tags");
        Map versions = (Map)rootJson.get("versions");
        distTags.put(version, version);
        versions.put(version, packageJson);
    }

    private void copyAttributes(Map<String, Object> higher, Map<String, Object> lower) {
        this.copyAttributeOrEnforce(higher, lower, "name");
        this.copyAttribute(higher, lower, "description");
        this.copyAttribute(higher, lower, "keywords");
        this.copyAttribute(higher, lower, "homepage");
    }

    private void copyAttributeOrEnforce(Map<String, Object> higher, Map<String, Object> lower, String attributeKey) {
        if (higher.containsKey(attributeKey) && lower.containsKey(attributeKey)) {
            Preconditions.checkArgument((boolean)Objects.equals(higher.get(attributeKey), lower.get(attributeKey)), (String)"inconsistent attribute: %s higher=%s, lower=%s", (Object[])new Object[]{attributeKey, higher.get(attributeKey), lower.get(attributeKey)});
        } else {
            this.copyAttribute(higher, lower, attributeKey);
        }
    }

    private void copyAttribute(Map<String, Object> higher, Map<String, Object> lower, String attributeKey) {
        if (lower.containsKey(attributeKey)) {
            higher.put(attributeKey, lower.get(attributeKey));
        }
    }
}

