/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.hosted;

import com.bolyuba.nexus.plugin.npm.hosted.NpmHostedRepository;
import com.bolyuba.nexus.plugin.npm.hosted.NpmHostedRepositoryConfiguration;
import com.bolyuba.nexus.plugin.npm.hosted.NpmHostedRepositoryConfigurator;
import com.bolyuba.nexus.plugin.npm.hosted.RecreateMetadataWalkerProcessor;
import com.bolyuba.nexus.plugin.npm.internal.NpmMimeRulesSource;
import com.bolyuba.nexus.plugin.npm.service.HostedMetadataService;
import com.bolyuba.nexus.plugin.npm.service.MetadataServiceFactory;
import com.bolyuba.nexus.plugin.npm.service.NpmBlob;
import com.bolyuba.nexus.plugin.npm.service.PackageRequest;
import com.bolyuba.nexus.plugin.npm.service.PackageRoot;
import com.bolyuba.nexus.plugin.npm.service.PackageVersion;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.sisu.Description;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.PreparedContentLocator;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.AbstractRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.walker.DefaultStoreWalkerFilter;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerFilter;

@Named(value="npm-hosted")
@Typed(value={Repository.class})
@Description(value="Npm registry hosted repo")
public class DefaultNpmHostedRepository
extends AbstractRepository
implements NpmHostedRepository,
Repository {
    public static final String ROLE_HINT = "npm-hosted";
    private final ContentClass contentClass;
    private final NpmHostedRepositoryConfigurator configurator;
    private final RepositoryKind repositoryKind;
    private final NpmMimeRulesSource mimeRulesSource;
    private final HostedMetadataService hostedMetadataService;

    @Inject
    public DefaultNpmHostedRepository(@Named(value="npm") ContentClass contentClass, NpmHostedRepositoryConfigurator configurator, MetadataServiceFactory metadataServiceFactory) {
        this.hostedMetadataService = metadataServiceFactory.createHostedMetadataService(this);
        this.mimeRulesSource = new NpmMimeRulesSource();
        this.contentClass = (ContentClass)Preconditions.checkNotNull((Object)contentClass);
        this.configurator = (NpmHostedRepositoryConfigurator)((Object)Preconditions.checkNotNull((Object)((Object)configurator)));
        this.repositoryKind = new DefaultRepositoryKind(NpmHostedRepository.class, null);
    }

    @Override
    public boolean recreateNpmMetadata() {
        DefaultWalkerContext context = new DefaultWalkerContext((Repository)this, new ResourceStoreRequest("/"), (WalkerFilter)new DefaultStoreWalkerFilter());
        RecreateMetadataWalkerProcessor processor = new RecreateMetadataWalkerProcessor(this.getMetadataService());
        context.getProcessors().add(processor);
        this.getWalker().walk((WalkerContext)context);
        this.log.info("Recreated npm metadata on {} (packageRoots={}/packageVersions={})", new Object[]{this, processor.getPackageRoots(), processor.getPackageVersions()});
        return processor.getPackageRoots() > 0;
    }

    @AllowConcurrentEvents
    @Subscribe
    public void onEvent(RepositoryRegistryEventRemove event) {
        if (event.getRepository() == this) {
            this.getMetadataService().deleteAllMetadata();
        }
    }

    @Override
    public HostedMetadataService getMetadataService() {
        return this.hostedMetadataService;
    }

    protected Configurator getConfigurator() {
        return this.configurator;
    }

    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    public MimeRulesSource getMimeRulesSource() {
        return this.mimeRulesSource;
    }

    protected CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<NpmHostedRepositoryConfiguration>(){

            public NpmHostedRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new NpmHostedRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    protected AbstractStorageItem doRetrieveLocalItem(ResourceStoreRequest storeRequest) throws ItemNotFoundException, LocalStorageException {
        try {
            if (!this.getMetadataService().isNpmMetadataServiced(storeRequest)) {
                return this.delegateDoRetrieveLocalItem(storeRequest);
            }
            PackageRequest packageRequest = null;
            try {
                packageRequest = new PackageRequest(storeRequest);
            }
            catch (IllegalArgumentException e) {
                return this.delegateDoRetrieveLocalItem(storeRequest);
            }
            if (packageRequest != null) {
                if (packageRequest.isMetadata()) {
                    ContentLocator contentLocator;
                    if (packageRequest.isRegistryRoot()) {
                        this.log.debug("Serving registry root...");
                        contentLocator = this.hostedMetadataService.produceRegistryRoot(packageRequest);
                    } else if (packageRequest.isPackageRoot()) {
                        this.log.debug("Serving package {} root...", (Object)packageRequest.getName());
                        contentLocator = this.hostedMetadataService.producePackageRoot(packageRequest);
                    } else {
                        this.log.debug("Serving package {} version {}...", (Object)packageRequest.getName(), (Object)packageRequest.getVersion());
                        contentLocator = this.hostedMetadataService.producePackageVersion(packageRequest);
                    }
                    if (contentLocator != null) {
                        return new DefaultStorageFileItem((Repository)this, storeRequest, true, true, contentLocator);
                    }
                } else {
                    if (packageRequest.isRegistrySpecial() && packageRequest.getPath().startsWith("/-/all")) {
                        this.log.debug("Serving registry root from /-/all...");
                        return new DefaultStorageFileItem((Repository)this, storeRequest, true, true, this.hostedMetadataService.produceRegistryRoot(packageRequest));
                    }
                    this.log.debug("Unknown registry special {}", (Object)packageRequest.getPath());
                }
            }
            this.log.debug("No NPM metadata for path {}", (Object)storeRequest.getRequestPath());
            throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)storeRequest, (Repository)this, (String)"No content for path %s", (Object[])new Object[]{storeRequest.getRequestPath()}));
        }
        catch (IOException e) {
            throw new LocalStorageException("Metadata service error", (Throwable)e);
        }
    }

    AbstractStorageItem delegateDoRetrieveLocalItem(ResourceStoreRequest storeRequest) throws LocalStorageException, ItemNotFoundException {
        return super.doRetrieveLocalItem(storeRequest);
    }

    public Action getResultingActionOnWrite(ResourceStoreRequest rsr) throws LocalStorageException {
        return this.getResultingActionOnWrite(rsr, null);
    }

    private Action getResultingActionOnWrite(ResourceStoreRequest rsr, PackageRoot packageRoot) throws LocalStorageException {
        try {
            if (packageRoot != null) {
                for (PackageVersion version : packageRoot.getVersions().values()) {
                    if (this.hostedMetadataService.generatePackageVersion(new PackageRequest(new ResourceStoreRequest("/" + version.getName() + "/" + version.getVersion()))) == null) continue;
                    return Action.update;
                }
                return Action.create;
            }
            try {
                PackageRequest packageRequest = new PackageRequest(rsr);
                if (packageRequest.isPackage()) {
                    return this.hostedMetadataService.generatePackageRoot(packageRequest) == null ? Action.create : Action.update;
                }
                return super.getResultingActionOnWrite(rsr);
            }
            catch (IllegalArgumentException e) {
                return super.getResultingActionOnWrite(rsr);
            }
        }
        catch (IOException e) {
            throw new LocalStorageException("Metadata service error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeItem(ResourceStoreRequest request, InputStream is, Map<String, String> userAttributes) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException, AccessDeniedException {
        block15: {
            try {
                PackageRequest packageRequest = null;
                try {
                    packageRequest = new PackageRequest(request);
                }
                catch (IllegalArgumentException e) {
                    super.storeItem(request, is, userAttributes);
                }
                if (packageRequest == null) break block15;
                if (!packageRequest.isPackageRoot()) {
                    throw new UnsupportedStorageOperationException("Store operations are only valid for package roots, path: " + packageRequest.getPath());
                }
                RepositoryItemUid publisherUid = this.createUid(packageRequest.getPath() + ".publish()");
                RepositoryItemUidLock publisherLock = publisherUid.getLock();
                publisherLock.lock(Action.create);
                try {
                    PackageRoot packageRoot = this.hostedMetadataService.parsePackageRoot(packageRequest, (ContentLocator)new PreparedContentLocator(is, "application/json", -1L));
                    try {
                        this.checkConditions(request, this.getResultingActionOnWrite(request, packageRoot));
                    }
                    catch (ItemNotFoundException e) {
                        throw new AccessDeniedException(request, e.getMessage());
                    }
                    packageRoot = this.hostedMetadataService.consumePackageRoot(packageRoot);
                    if (!packageRoot.getAttachments().isEmpty()) {
                        for (NpmBlob attachment : packageRoot.getAttachments().values()) {
                            try {
                                ResourceStoreRequest attachmentRequest = new ResourceStoreRequest(request);
                                attachmentRequest.setRequestPath(packageRequest.getPath() + "/" + "-" + "/" + attachment.getName());
                                super.storeItem(attachmentRequest, attachment.getContent(), userAttributes);
                            }
                            finally {
                                attachment.delete();
                            }
                        }
                    }
                }
                finally {
                    publisherLock.unlock();
                }
            }
            catch (IOException e) {
                throw new LocalStorageException("Upload problem", (Throwable)e);
            }
        }
    }

    public void deleteItem(boolean fromTask, ResourceStoreRequest storeRequest) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException {
        block8: {
            PackageRequest packageRequest = null;
            try {
                packageRequest = new PackageRequest(storeRequest);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            boolean supressItemNotFound = false;
            if (packageRequest != null && packageRequest.isMetadata()) {
                if (packageRequest.isRegistryRoot()) {
                    this.log.debug("Deleting registry root...");
                    this.getMetadataService().deleteAllMetadata();
                } else if (packageRequest.isPackageRoot()) {
                    this.log.debug("Deleting package {} root...", (Object)packageRequest.getName());
                    supressItemNotFound = this.getMetadataService().deletePackage(packageRequest.getName());
                }
            }
            try {
                super.deleteItem(fromTask, storeRequest);
            }
            catch (ItemNotFoundException e) {
                if (supressItemNotFound) break block8;
                throw e;
            }
        }
    }
}

