/*
 * Decompiled with CFR 0.152.
 */
package com.bolyuba.nexus.plugin.npm.group;

import com.bolyuba.nexus.plugin.npm.group.NpmGroupRepository;
import com.bolyuba.nexus.plugin.npm.group.NpmGroupRepositoryConfiguration;
import com.bolyuba.nexus.plugin.npm.group.NpmGroupRepositoryConfigurator;
import com.bolyuba.nexus.plugin.npm.internal.NpmMimeRulesSource;
import com.bolyuba.nexus.plugin.npm.service.GroupMetadataService;
import com.bolyuba.nexus.plugin.npm.service.MetadataServiceFactory;
import com.bolyuba.nexus.plugin.npm.service.PackageRequest;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.sisu.Description;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.AbstractGroupRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;

@Named(value="npm-group")
@Typed(value={GroupRepository.class})
@Description(value="Npm registry group repo")
public class DefaultNpmGroupRepository
extends AbstractGroupRepository
implements NpmGroupRepository,
GroupRepository {
    public static final String ROLE_HINT = "npm-group";
    private final ContentClass contentClass;
    private final NpmGroupRepositoryConfigurator configurator;
    private final RepositoryKind repositoryKind;
    private final NpmMimeRulesSource mimeRulesSource;
    private final GroupMetadataService groupMetadataService;

    @Inject
    public DefaultNpmGroupRepository(@Named(value="npm") ContentClass contentClass, NpmGroupRepositoryConfigurator configurator, MetadataServiceFactory metadataServiceFactory) {
        this.groupMetadataService = metadataServiceFactory.createGroupMetadataService(this);
        this.mimeRulesSource = new NpmMimeRulesSource();
        this.contentClass = (ContentClass)Preconditions.checkNotNull((Object)contentClass);
        this.configurator = (NpmGroupRepositoryConfigurator)((Object)Preconditions.checkNotNull((Object)((Object)configurator)));
        this.repositoryKind = new DefaultRepositoryKind(NpmGroupRepository.class, null);
    }

    @Override
    public GroupMetadataService getMetadataService() {
        return this.groupMetadataService;
    }

    protected Configurator getConfigurator() {
        return this.configurator;
    }

    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    public MimeRulesSource getMimeRulesSource() {
        return this.mimeRulesSource;
    }

    protected CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<NpmGroupRepositoryConfiguration>(){

            public NpmGroupRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new NpmGroupRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    protected AbstractStorageItem doRetrieveLocalItem(ResourceStoreRequest storeRequest) throws ItemNotFoundException, LocalStorageException {
        if (!this.getMetadataService().isNpmMetadataServiced(storeRequest)) {
            return super.doRetrieveLocalItem(storeRequest);
        }
        try {
            PackageRequest packageRequest = null;
            try {
                packageRequest = new PackageRequest(storeRequest);
            }
            catch (IllegalArgumentException e) {
                return super.doRetrieveLocalItem(storeRequest);
            }
            if (packageRequest != null) {
                if (packageRequest.isMetadata()) {
                    ContentLocator contentLocator;
                    if (packageRequest.isRegistryRoot()) {
                        this.log.debug("Serving registry root...");
                        contentLocator = this.groupMetadataService.produceRegistryRoot(packageRequest);
                    } else if (packageRequest.isPackageRoot()) {
                        this.log.debug("Serving package {} root...", (Object)packageRequest.getName());
                        contentLocator = this.groupMetadataService.producePackageRoot(packageRequest);
                    } else {
                        this.log.debug("Serving package {} version {}...", (Object)packageRequest.getName(), (Object)packageRequest.getVersion());
                        contentLocator = this.groupMetadataService.producePackageVersion(packageRequest);
                    }
                    if (contentLocator != null) {
                        return new DefaultStorageFileItem((Repository)this, storeRequest, true, true, contentLocator);
                    }
                } else {
                    if (packageRequest.isRegistrySpecial() && packageRequest.getPath().startsWith("/-/all")) {
                        this.log.debug("Serving registry root from /-/all...");
                        return new DefaultStorageFileItem((Repository)this, storeRequest, true, true, this.groupMetadataService.produceRegistryRoot(packageRequest));
                    }
                    this.log.debug("Unknown registry special {}", (Object)packageRequest.getPath());
                }
            }
            this.log.debug("No NPM metadata for path {}", (Object)storeRequest.getRequestPath());
            throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)storeRequest, (Repository)this, (String)"No content for path %s", (Object[])new Object[]{storeRequest.getRequestPath()}));
        }
        catch (IOException e) {
            throw new LocalStorageException("Metadata service error", (Throwable)e);
        }
    }
}

