/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest.xstream.json;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.core.util.Primitives;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class PrimitiveKeyedMapConverter
extends AbstractCollectionConverter {
    public PrimitiveKeyedMapConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return type.equals(HashMap.class) || type.equals(Hashtable.class) || type.getName().equals("java.util.LinkedHashMap") || type.getName().equals("sun.font.AttributeMap");
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map = (Map)source;
        for (Map.Entry entry : map.entrySet()) {
            Class pClass = Primitives.unbox(entry.getKey().getClass());
            if (!(String.class.equals(entry.getKey().getClass()) || entry.getKey().getClass().isPrimitive() || pClass != null && pClass.isPrimitive())) {
                throw new IllegalArgumentException("Cannot convert maps with non-String keys!");
            }
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)entry.getKey().toString(), entry.getValue().getClass());
            context.convertAnother(entry.getValue());
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Map map = (Map)this.createCollection(context.getRequiredType());
        this.populateMap(reader, context, map);
        return map;
    }

    protected void populateMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map) {
        while (reader.hasMoreChildren()) {
            Object value;
            reader.moveDown();
            String key = reader.getNodeName();
            if (reader.hasMoreChildren()) {
                value = this.readItem(reader, context, map);
            } else {
                String classAttribute = reader.getAttribute(this.mapper().aliasForAttribute("class"));
                Class type = classAttribute == null ? this.mapper().realClass(key) : this.mapper().realClass(classAttribute);
                value = context.convertAnother((Object)reader.getValue(), type);
            }
            map.put(key, value);
            reader.moveUp();
        }
    }
}

