/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest.xstream.json;

import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONWriter;
import org.sonatype.plexus.rest.xstream.json.NodeType;

public class JsonOrgHierarchicalStreamWriter
implements ExtendedHierarchicalStreamWriter {
    private final Writer writer;
    private final FastStack elementStack = new FastStack(16);
    private final boolean createTopLevelEnvelope;
    private JSONWriter jsonWriter;

    public JsonOrgHierarchicalStreamWriter(Writer writer, boolean createTopLevelEnvelope) {
        this.writer = writer;
        this.createTopLevelEnvelope = createTopLevelEnvelope;
        this.jsonWriter = new JSONWriter(writer);
    }

    public void startNode(String name) {
        this.startNode(name, Object.class);
    }

    public void startNode(String name, Class clazz) {
        Node currNode = (Node)this.elementStack.peek();
        NodeType nt = null;
        try {
            if (currNode == null && this.createTopLevelEnvelope) {
                this.jsonWriter.object();
                currNode = new Node("root", Object.class, NodeType.OBJECT);
            }
            if (currNode != null && currNode.nodeType == NodeType.OBJECT) {
                this.jsonWriter.key(name);
            }
            if (clazz == null) {
                this.jsonWriter.value(null);
            } else if (Collection.class.isAssignableFrom(clazz) || clazz.isArray()) {
                this.jsonWriter.array();
                nt = NodeType.ARRAY;
            } else if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
                nt = NodeType.BOOLEAN;
            } else if (Integer.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
                nt = NodeType.NUMBER;
            } else if (String.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
                nt = NodeType.STRING;
            } else if (Date.class.isAssignableFrom(clazz)) {
                nt = NodeType.DATE;
            } else {
                this.jsonWriter.object();
                nt = NodeType.OBJECT;
            }
        }
        catch (JSONException e) {
            throw new StreamException((Throwable)e);
        }
        this.elementStack.push((Object)new Node(name, clazz, nt));
    }

    public void addAttribute(String name, String value) {
        try {
            this.jsonWriter.key('@' + name).value((Object)value);
        }
        catch (JSONException e) {
            throw new StreamException((Throwable)e);
        }
    }

    public void setValue(String text) {
        Node node = (Node)this.elementStack.peek();
        try {
            switch (node.nodeType) {
                case STRING: {
                    this.jsonWriter.value((Object)text);
                    break;
                }
                case NUMBER: {
                    this.jsonWriter.value(Long.parseLong(text));
                    break;
                }
                case BOOLEAN: {
                    this.jsonWriter.value(Boolean.parseBoolean(text));
                    break;
                }
                case DATE: {
                    this.jsonWriter.value((Object)text);
                }
            }
        }
        catch (JSONException e) {
            throw new StreamException((Throwable)e);
        }
    }

    public void endNode() {
        Node node = (Node)this.elementStack.pop();
        try {
            switch (node.nodeType) {
                case OBJECT: {
                    this.jsonWriter.endObject();
                    break;
                }
                case ARRAY: {
                    this.jsonWriter.endArray();
                    break;
                }
            }
            if (!this.elementStack.hasStuff() && this.createTopLevelEnvelope) {
                this.jsonWriter.endObject();
            }
        }
        catch (JSONException e) {
            throw new StreamException((Throwable)e);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new StreamException((Throwable)e);
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new StreamException((Throwable)e);
        }
    }

    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }

    public class Node {
        public final String name;
        public final Class clazz;
        public final NodeType nodeType;

        public Node(String name, Class clazz, NodeType type) {
            this.name = name;
            this.clazz = clazz;
            this.nodeType = type;
        }
    }
}

