/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest.xstream.json;

import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.StreamException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.sonatype.plexus.rest.xstream.LookAheadStreamReader;
import org.sonatype.plexus.rest.xstream.json.ClassHintProvider;
import org.sonatype.plexus.rest.xstream.json.NodeType;

public class JsonOrgHierarchicalStreamReader
implements HierarchicalStreamReader,
LookAheadStreamReader {
    private ClassHintProvider classHintProvider;
    private FastStack objects = new FastStack(16);
    private Node currentNode;
    private String currentKey;

    public JsonOrgHierarchicalStreamReader(Reader reader, boolean expectTopLevelEnvelope) {
        this.setUp(reader, expectTopLevelEnvelope);
    }

    public JsonOrgHierarchicalStreamReader(Reader reader, boolean expectTopLevelEnvelope, ClassHintProvider classHintProvider) {
        this.classHintProvider = classHintProvider;
        this.setUp(reader, expectTopLevelEnvelope);
    }

    protected void setUp(Reader reader, boolean expectTopLevelEnvelope) {
        block10: {
            StringBuffer jsonStringB = new StringBuffer();
            BufferedReader in = new BufferedReader(reader);
            String x = null;
            try {
                x = in.readLine();
                while (x != null) {
                    jsonStringB.append(x);
                    x = in.readLine();
                }
                in.close();
                String jsonString = jsonStringB.toString().trim();
                if (expectTopLevelEnvelope) {
                    if (jsonString.startsWith("[")) {
                        throw new StreamException("JSON root element must be JSONObject with one member, and it must start with '{' (expectTopLevelEnvelope is TRUE)!");
                    }
                    if (jsonString.startsWith("{")) {
                        JSONObject jsonObject = new JSONObject(jsonString.toString());
                        String[] keys = JSONObject.getNames((JSONObject)jsonObject);
                        if (keys.length == 1) {
                            this.currentKey = keys[0];
                            this.currentNode = new Node(this.currentKey, jsonObject.get(this.currentKey));
                            break block10;
                        }
                        throw new StreamException("JSON root element must be JSONObject with one member, and it must start with '{' (expectTopLevelEnvelope is TRUE)!");
                    }
                    throw new StreamException("JSON root element must be JSONObject, it must start with '{'!");
                }
                this.currentKey = this.classHintProvider == null ? "this" : this.classHintProvider.getRootClass();
                if (jsonString.startsWith("[")) {
                    this.currentNode = new Node(this.currentKey, new JSONArray(jsonString.toString()));
                    break block10;
                }
                if (jsonString.startsWith("{")) {
                    this.currentNode = new Node(this.currentKey, new JSONObject(jsonString.toString()));
                    break block10;
                }
                throw new StreamException("JSON root element must be JSONObject or JSONArray, it must start with '{' or '['!");
            }
            catch (IOException e) {
                throw new StreamException((Throwable)e);
            }
            catch (JSONException e) {
                throw new StreamException((Throwable)e);
            }
        }
    }

    public void close() {
    }

    public void appendErrors(ErrorWriter errorWriter) {
    }

    public String getAttribute(String name) {
        if ("class".equals(name)) {
            if (this.classHintProvider != null) {
                this.classHintProvider.getFieldClass(this.currentNode.name);
            }
            if (this.currentNode.valueNull) {
                return "null";
            }
            switch (this.currentNode.nodeType) {
                case STRING: {
                    return "string";
                }
                case NUMBER: {
                    return "int";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case ARRAY: {
                    return null;
                }
                case DATE: {
                    return "date";
                }
            }
            Object obj = ((JSONObject)this.currentNode.jsonObject).opt("@class");
            if (obj != null) {
                return obj.toString();
            }
            return null;
        }
        if (this.currentNode.nodeType == NodeType.OBJECT && !this.currentNode.valueNull) {
            Object obj = ((JSONObject)this.currentNode.jsonObject).opt("@" + name);
            if (obj != null) {
                return obj.toString();
            }
            return null;
        }
        return null;
    }

    public String getAttribute(int index) {
        if (this.currentNode.nodeType == NodeType.OBJECT) {
            return this.getAttribute(this.getAttributeName(index));
        }
        return null;
    }

    public int getAttributeCount() {
        if (this.currentNode.nodeType == NodeType.OBJECT && !this.currentNode.valueNull) {
            return this.currentNode.attributes.size();
        }
        return 0;
    }

    public String getAttributeName(int index) {
        if (this.currentNode.nodeType == NodeType.OBJECT && !this.currentNode.valueNull) {
            return this.currentNode.attributes.get(index);
        }
        return null;
    }

    public Iterator getAttributeNames() {
        if (this.currentNode.nodeType == NodeType.OBJECT && !this.currentNode.valueNull) {
            return this.currentNode.attributes.iterator();
        }
        return new EmptyIterator();
    }

    public String getNodeName() {
        Node parent = (Node)this.objects.peek();
        if (parent != null && parent.nodeType == NodeType.ARRAY) {
            switch (this.currentNode.nodeType) {
                case STRING: {
                    return "string";
                }
                case NUMBER: {
                    return "int";
                }
                case BOOLEAN: {
                    return "boolean";
                }
            }
            return this.currentNode.name;
        }
        return this.currentNode.name;
    }

    public String getValue() {
        if (this.currentNode.nodeType == NodeType.STRING || this.currentNode.nodeType == NodeType.BOOLEAN || this.currentNode.nodeType == NodeType.NUMBER) {
            if (this.currentNode.valueNull) {
                return null;
            }
            return this.currentNode.jsonObject.toString();
        }
        return null;
    }

    public boolean hasMoreChildren() {
        return this.currentNode.keys != null && this.currentNode.keys.hasNext();
    }

    public void moveDown() {
        this.objects.push((Object)this.currentNode);
        this.currentNode = new Node((String)this.currentNode.keys.next(), this.currentNode.values.next());
    }

    public void moveUp() {
        this.currentNode = (Node)this.objects.pop();
    }

    public HierarchicalStreamReader underlyingReader() {
        return this;
    }

    @Override
    public String getFieldValue(String fieldName) {
        if (this.currentNode.nodeType == NodeType.OBJECT) {
            return ((JSONObject)this.currentNode.jsonObject).optString(fieldName);
        }
        return null;
    }

    public class Node {
        public final String name;
        public final NodeType nodeType;
        public final Object jsonObject;
        public final boolean valueNull;
        public final Iterator keys;
        public final Iterator values;
        public final List<String> attributes;

        public Node(String name, Object object) {
            this.name = name;
            this.jsonObject = object;
            if (object instanceof Boolean) {
                this.nodeType = NodeType.BOOLEAN;
                this.valueNull = false;
                this.keys = null;
                this.values = null;
                this.attributes = null;
            } else if (object instanceof Number) {
                this.nodeType = NodeType.NUMBER;
                this.valueNull = false;
                this.keys = null;
                this.values = null;
                this.attributes = null;
            } else if (object.getClass().isAssignableFrom(String.class)) {
                this.nodeType = NodeType.STRING;
                this.valueNull = false;
                this.keys = null;
                this.values = null;
                this.attributes = null;
            } else if (object.getClass().isAssignableFrom(JSONArray.class)) {
                this.nodeType = NodeType.ARRAY;
                this.valueNull = false;
                this.keys = new IntegerIterator(((JSONArray)object).length());
                this.values = new ArrayValuesIterator((JSONArray)object);
                this.attributes = null;
            } else if (object.getClass().isAssignableFrom(Date.class)) {
                this.nodeType = NodeType.DATE;
                this.valueNull = false;
                this.keys = null;
                this.values = null;
                this.attributes = null;
            } else {
                this.nodeType = NodeType.OBJECT;
                this.valueNull = JSONObject.NULL.equals(object);
                if (this.valueNull) {
                    this.keys = null;
                    this.values = null;
                    this.attributes = null;
                } else {
                    this.attributes = new ArrayList<String>();
                    ArrayList<String> filteredKeys = new ArrayList<String>();
                    Iterator keys = ((JSONObject)object).keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if (key.startsWith("@")) {
                            this.attributes.add(key.substring(1));
                            continue;
                        }
                        filteredKeys.add(key);
                    }
                    this.keys = filteredKeys.iterator();
                    this.values = new ObjectValuesIterator((JSONObject)object, filteredKeys.iterator());
                }
            }
        }

        public String toString() {
            return this.name + " :: " + (this.jsonObject != null ? this.jsonObject.toString() : "");
        }
    }

    public class ObjectValuesIterator
    implements Iterator {
        private JSONObject object;
        private Iterator keys;

        public ObjectValuesIterator(JSONObject object, Iterator keys) {
            this.object = object;
            this.keys = keys;
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            try {
                return this.object.get((String)this.keys.next());
            }
            catch (JSONException e) {
                throw new StreamException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation remove not supported!");
        }
    }

    public class ArrayValuesIterator
    implements Iterator {
        private JSONArray array;
        private int ptr;

        public ArrayValuesIterator(JSONArray array) {
            this.array = array;
            this.ptr = 0;
        }

        @Override
        public boolean hasNext() {
            return this.ptr < this.array.length() - 1;
        }

        public Object next() {
            try {
                return this.array.get(this.ptr++);
            }
            catch (JSONException e) {
                throw new StreamException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation remove not supported!");
        }
    }

    public class IntegerIterator
    implements Iterator {
        private int max;
        private int ptr;

        public IntegerIterator(int max) {
            this.max = max;
            this.ptr = -1;
        }

        @Override
        public boolean hasNext() {
            return this.ptr < this.max - 1;
        }

        public Object next() {
            return Integer.toString(++this.ptr);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation remove not supported!");
        }
    }

    public class EmptyIterator
    implements Iterator {
        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new UnsupportedOperationException("Operation remove not supported!");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation remove not supported!");
        }
    }
}

