/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest.xstream.json;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.sonatype.plexus.rest.xstream.json.ClassHintProvider;
import org.sonatype.plexus.rest.xstream.json.JsonOrgHierarchicalStreamReader;
import org.sonatype.plexus.rest.xstream.json.JsonOrgHierarchicalStreamWriter;

public class JsonOrgHierarchicalStreamDriver
implements HierarchicalStreamDriver {
    private ClassHintProvider classHintProvider;

    public JsonOrgHierarchicalStreamDriver() {
        this(null);
    }

    public JsonOrgHierarchicalStreamDriver(ClassHintProvider classHintProvider) {
        this.classHintProvider = classHintProvider;
    }

    public HierarchicalStreamReader createReader(Reader in) {
        if (this.classHintProvider != null) {
            return new JsonOrgHierarchicalStreamReader(in, false, this.classHintProvider);
        }
        return new JsonOrgHierarchicalStreamReader(in, true);
    }

    public HierarchicalStreamReader createReader(InputStream in) {
        return this.createReader(new InputStreamReader(in));
    }

    public HierarchicalStreamReader createReader(URL in) {
        try {
            return this.createReader(in.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public HierarchicalStreamReader createReader(File in) {
        try {
            return this.createReader(new BufferedReader(new FileReader(in)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer out) {
        return new JsonOrgHierarchicalStreamWriter(out, false);
    }

    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out));
    }
}

