/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest.resource;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileUploadException;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.ResourceException;
import org.restlet.resource.StringRepresentation;
import org.restlet.resource.Variant;
import org.slf4j.Logger;
import org.sonatype.plexus.rest.representation.InputStreamRepresentation;
import org.sonatype.plexus.rest.representation.XStreamRepresentation;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.plexus.rest.resource.RestletResponseCustomizer;
import org.sonatype.sisu.goodies.common.Loggers;

public class RestletResource
extends Resource {
    protected final Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass());
    private PlexusResource delegate;

    public RestletResource(Context context, Request request, Response response, PlexusResource delegate) {
        super(context, request, response);
        this.delegate = delegate;
        this.getVariants().clear();
        this.getVariants().addAll(delegate.getVariants());
        this.setAvailable(delegate.isAvailable());
        this.setReadable(delegate.isReadable());
        this.setModifiable(delegate.isModifiable());
        this.setNegotiateContent(delegate.isNegotiateContent());
    }

    protected FileItemFactory getFileItemFactory() {
        return (FileItemFactory)this.getContext().getAttributes().get("plexus.fileItemFactory");
    }

    protected XStreamRepresentation createRepresentation(Variant variant) throws ResourceException {
        XStreamRepresentation representation = null;
        try {
            if (MediaType.APPLICATION_JSON.equals((Object)variant.getMediaType(), true) || MediaType.APPLICATION_XML.equals((Object)variant.getMediaType(), true) || MediaType.TEXT_HTML.equals((Object)variant.getMediaType(), true)) {
                XStream xstream;
                String text;
                String string = text = variant instanceof Representation ? ((Representation)variant).getText() : "";
                if (MediaType.APPLICATION_JSON.equals((Object)variant.getMediaType(), true) || MediaType.TEXT_HTML.equals((Object)variant.getMediaType(), true)) {
                    xstream = (XStream)this.getContext().getAttributes().get("plexus.xstream.json");
                } else if (MediaType.APPLICATION_XML.equals((Object)variant.getMediaType(), true)) {
                    xstream = (XStream)this.getContext().getAttributes().get("plexus.xstream.xml");
                } else {
                    return null;
                }
                if (text != null) {
                    CharacterSet charset = variant.getCharacterSet();
                    if (charset == null) {
                        charset = CharacterSet.ISO_8859_1;
                    }
                    if (!CharacterSet.UTF_8.equals((Object)charset)) {
                        text = new String(new String(text.getBytes(), "UTF-8").getBytes(charset.getName()));
                    }
                }
                representation = new XStreamRepresentation(xstream, text, variant.getMediaType());
                return representation;
            }
            return null;
        }
        catch (IOException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Cannot get the representation!", (Throwable)e);
        }
    }

    protected Representation serialize(Variant variant, Object payload) throws ResourceException {
        if (payload == null) {
            return null;
        }
        XStreamRepresentation result = this.createRepresentation(variant);
        if (result == null) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_ACCEPTABLE, "The requested mediaType='" + variant.getMediaType() + "' is unsupported!");
        }
        result.setPayload(payload);
        return result;
    }

    protected Object deserialize(Object root) throws ResourceException {
        Object result = null;
        if (root != null) {
            XStreamRepresentation representation;
            if (String.class.isAssignableFrom(root.getClass())) {
                try {
                    result = this.getRequest().getEntity().getText();
                }
                catch (IOException e) {
                    throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Cannot get the representation!", (Throwable)e);
                }
            }
            if ((representation = this.createRepresentation((Variant)this.getRequest().getEntity())) != null) {
                try {
                    result = representation.getPayload(root);
                }
                catch (XStreamException e) {
                    this.logger.warn("Invalid XML, unable to parse using XStream {}", this.delegate == null ? "" : this.delegate.getClass(), (Object)e);
                    throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid XML, unable to parse using XStream", (Throwable)e);
                }
            }
        }
        return result;
    }

    protected Representation doRepresent(Object payload, Variant variant) throws ResourceException {
        if (Representation.class.isAssignableFrom(payload.getClass())) {
            return (Representation)payload;
        }
        if (InputStream.class.isAssignableFrom(payload.getClass())) {
            return new InputStreamRepresentation(variant.getMediaType(), (InputStream)payload);
        }
        if (String.class.isAssignableFrom(payload.getClass())) {
            return new StringRepresentation((CharSequence)((String)payload), variant.getMediaType());
        }
        return this.serialize(variant, payload);
    }

    private Representation doRepresent(Object payload, Variant variant, Response response) throws ResourceException {
        Representation representation = this.doRepresent(payload, variant);
        if (representation != null && representation instanceof RestletResponseCustomizer) {
            ((RestletResponseCustomizer)representation).customize(response);
        }
        return representation;
    }

    public boolean allowMkcol() {
        return false;
    }

    public Representation represent(Variant variant) throws ResourceException {
        Object result;
        try {
            result = this.delegate.get(this.getContext(), this.getRequest(), this.getResponse(), variant);
        }
        catch (PlexusResourceException e) {
            this.getResponse().setStatus(e.getStatus());
            result = e.getResultObject();
        }
        return result != null ? this.doRepresent(result, variant, this.getResponse()) : null;
    }

    public void acceptRepresentation(Representation representation) throws ResourceException {
        if (this.delegate.acceptsUpload()) {
            this.upload(representation);
        } else {
            Object payloadInstance = this.delegate.getPayloadInstance(Method.POST);
            if (payloadInstance == null) {
                payloadInstance = this.delegate.getPayloadInstance();
            }
            Object payload = this.deserialize(payloadInstance);
            Object result = null;
            try {
                result = this.delegate.post(this.getContext(), this.getRequest(), this.getResponse(), payload);
                if (this.getResponse().getStatus() == Status.SUCCESS_OK) {
                    this.getResponse().setStatus(Status.SUCCESS_CREATED);
                }
            }
            catch (PlexusResourceException e) {
                this.getResponse().setStatus(e.getStatus());
                result = e.getResultObject();
            }
            if (result != null) {
                this.getResponse().setEntity(this.doRepresent(result, (Variant)representation, this.getResponse()));
            }
        }
    }

    public void storeRepresentation(Representation representation) throws ResourceException {
        if (this.delegate.acceptsUpload()) {
            this.upload(representation);
        } else {
            Object payloadInstance = this.delegate.getPayloadInstance(Method.PUT);
            if (payloadInstance == null) {
                payloadInstance = this.delegate.getPayloadInstance();
            }
            Object payload = this.deserialize(payloadInstance);
            Object result = null;
            try {
                result = this.delegate.put(this.getContext(), this.getRequest(), this.getResponse(), payload);
            }
            catch (PlexusResourceException e) {
                this.getResponse().setStatus(e.getStatus());
                result = e.getResultObject();
            }
            if (result != null) {
                this.getResponse().setEntity(this.doRepresent(result, (Variant)representation, this.getResponse()));
            }
        }
    }

    public void removeRepresentations() throws ResourceException {
        this.delegate.delete(this.getContext(), this.getRequest(), this.getResponse());
        if (this.getResponse().getStatus() == Status.SUCCESS_OK && !this.getResponse().isEntityAvailable()) {
            this.getResponse().setStatus(Status.SUCCESS_NO_CONTENT);
        }
    }

    public void handleOptions() {
        super.handleOptions();
        try {
            this.delegate.options(this.getContext(), this.getRequest(), this.getResponse());
        }
        catch (ResourceException re) {
            this.getResponse().setStatus(re.getStatus(), (Throwable)re);
        }
    }

    public void upload(Representation representation) throws ResourceException {
        Object result = null;
        ArrayList<FileItem> files = null;
        try {
            RestletFileUpload uploadRequest = new RestletFileUpload(this.getFileItemFactory());
            files = uploadRequest.parseRepresentation(representation);
            result = this.delegate.upload(this.getContext(), this.getRequest(), this.getResponse(), (List<FileItem>)files);
        }
        catch (FileUploadException e) {
            String name = this.getRequest().getResourceRef().getPath();
            if (name.contains("/")) {
                name = name.substring(name.lastIndexOf("/") + 1, name.length());
            }
            FakeFileItem file = new FakeFileItem(name, representation);
            files = new ArrayList<FileItem>();
            files.add(file);
            result = this.delegate.upload(this.getContext(), this.getRequest(), this.getResponse(), files);
        }
        if (this.getResponse().getStatus() == Status.SUCCESS_OK) {
            this.getResponse().setStatus(Status.SUCCESS_CREATED);
        }
        if (result != null) {
            this.getResponse().setEntity(this.doRepresent(result, this.getPreferredVariant(), this.getResponse()));
        }
    }

    private class FakeFileItem
    implements FileItem {
        private static final long serialVersionUID = 414885488690939983L;
        private final String name;
        private final Representation representation;

        public FakeFileItem(String name, Representation representation) {
            this.name = name;
            this.representation = representation;
        }

        public String getContentType() {
            return this.representation.getMediaType().getName();
        }

        public String getName() {
            return this.name;
        }

        public String getFieldName() {
            return this.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.representation.getStream();
        }

        public void delete() {
        }

        public byte[] get() {
            return null;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public long getSize() {
            return 0L;
        }

        public String getString() {
            return null;
        }

        public String getString(String encoding) throws UnsupportedEncodingException {
            return null;
        }

        public boolean isFormField() {
            return false;
        }

        public boolean isInMemory() {
            return false;
        }

        public void setFieldName(String name) {
        }

        public void setFormField(boolean state) {
        }

        public void write(File file) throws Exception {
        }

        public FileItemHeaders getHeaders() {
            return null;
        }

        public void setHeaders(FileItemHeaders headers) {
        }
    }
}

