/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest.resource;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.slf4j.Logger;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.sisu.goodies.common.Loggers;

public abstract class AbstractPlexusResource
implements PlexusResource {
    private final Logger logger = Loggers.getLogger(this.getClass());
    private boolean available = true;
    private boolean readable = true;
    private boolean modifiable = false;
    private boolean negotiateContent = true;
    private boolean requireStrictChecking = true;

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    @Override
    public boolean isNegotiateContent() {
        return this.negotiateContent;
    }

    public void setNegotiateContent(boolean negotiateContent) {
        this.negotiateContent = negotiateContent;
    }

    @Override
    public abstract String getResourceUri();

    @Override
    public abstract PathProtectionDescriptor getResourceProtection();

    @Override
    public abstract Object getPayloadInstance();

    @Override
    public List<Variant> getVariants() {
        ArrayList<Variant> result = new ArrayList<Variant>();
        result.add(new Variant(MediaType.APPLICATION_XML));
        result.add(new Variant(MediaType.APPLICATION_JSON));
        return result;
    }

    @Override
    public boolean acceptsUpload() {
        return false;
    }

    @Override
    public boolean requireStrictChecking() {
        return this.requireStrictChecking;
    }

    public void setRequireStrictChecking(boolean requireStrictChecking) {
        this.requireStrictChecking = requireStrictChecking;
    }

    @Override
    public void configureXStream(XStream xstream) {
    }

    @Override
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        throw new ResourceException(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
    }

    @Override
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        throw new ResourceException(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
    }

    @Override
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        throw new ResourceException(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
    }

    @Override
    public void delete(Context context, Request request, Response response) throws ResourceException {
        throw new ResourceException(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
    }

    @Override
    public Object upload(Context context, Request request, Response response, List<FileItem> files) throws ResourceException {
        throw new ResourceException(Status.SERVER_ERROR_NOT_IMPLEMENTED);
    }

    @Override
    public void options(Context context, Request request, Response response) throws ResourceException {
    }

    @Override
    public Object getPayloadInstance(Method method) {
        return this.getPayloadInstance();
    }

    public static void addHttpResponseHeader(Response response, String name, String value) {
        Form responseHeaders = (Form)response.getAttributes().get("org.restlet.http.headers");
        if (responseHeaders == null) {
            responseHeaders = new Form();
            response.getAttributes().put("org.restlet.http.headers", responseHeaders);
        }
        responseHeaders.add(name, value);
    }
}

