/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest.representation;

import java.util.Map;
import javax.inject.Provider;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.ext.velocity.TemplateRepresentation;

public class VelocityRepresentation
extends TemplateRepresentation {
    private final VelocityEngine velocityEngine;

    public VelocityRepresentation(Context context, Template template, Map<String, Object> dataModel, MediaType mediaType) {
        super(template, dataModel, mediaType);
        this.velocityEngine = VelocityRepresentation.getEngine(context);
    }

    public VelocityRepresentation(Context context, String templateName, ClassLoader cl, Map<String, Object> dataModel, MediaType mediaType) {
        this(context, VelocityRepresentation.getTemplate(context, templateName, cl), dataModel, mediaType);
    }

    public VelocityEngine getEngine() {
        return this.velocityEngine;
    }

    public static Template getTemplate(Context context, String templateName, ClassLoader cl) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            Template template = VelocityRepresentation.getEngine(context).getTemplate(templateName);
            return template;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot get the template with name " + String.valueOf(templateName), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private static VelocityEngine getEngine(Context context) {
        return (VelocityEngine)((Provider)context.getAttributes().get(VelocityEngine.class.getName())).get();
    }
}

