/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest;

import com.noelios.restlet.ext.servlet.ServerServlet;
import com.noelios.restlet.ext.servlet.ServletContextAdapter;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.service.TaskService;

public class PlexusServerServlet
extends ServerServlet {
    private static final long serialVersionUID = 2636935931764462049L;

    public PlexusContainer getPlexusContainer() {
        return (PlexusContainer)this.getServletContext().getAttribute("plexus");
    }

    public void destroy() {
        if (this.getApplication() != null && this.getApplication().isStarted()) {
            try {
                try {
                    TaskService taskService = this.getApplication().getTaskService();
                    if (taskService != null) {
                        taskService.setShutdownAllowed(true);
                        taskService.shutdownNow();
                    }
                }
                finally {
                    this.getApplication().stop();
                }
            }
            catch (Exception e) {
                this.log("Error during the stopping of the Restlet Application", e);
            }
        }
        super.destroy();
    }

    public Application createApplication(Context context) {
        String initParam;
        Application application = null;
        String applicationRole = this.getInitParameter("role", Application.class.getName());
        String applicationRoleHint = this.getInitParameter("roleHint", null);
        try {
            application = applicationRoleHint != null ? (Application)this.getPlexusContainer().lookup(applicationRole, applicationRoleHint) : (Application)this.getPlexusContainer().lookup(applicationRole);
        }
        catch (ComponentLookupException e) {
            throw new IllegalStateException("The PlexusServerServlet couldn't lookup the target component (role='" + applicationRole + "', hint='" + applicationRoleHint + "')", e);
        }
        application.setName(this.getServletConfig().getServletName());
        application.setContext((Context)new ServletContextAdapter((Servlet)this, context));
        application.getContext().setLogger(application.getClass().getName());
        Context applicationContext = application.getContext();
        ServletConfig servletConfig = this.getServletConfig();
        Enumeration enum1 = servletConfig.getInitParameterNames();
        while (enum1.hasMoreElements()) {
            initParam = (String)enum1.nextElement();
            applicationContext.getParameters().add(initParam, servletConfig.getInitParameter(initParam));
        }
        enum1 = this.getServletContext().getInitParameterNames();
        while (enum1.hasMoreElements()) {
            initParam = (String)enum1.nextElement();
            applicationContext.getParameters().add(initParam, this.getServletContext().getInitParameter(initParam));
        }
        return application;
    }

    public String getInitParameter(String name, String defaultValue) {
        String prefixedName = this.getServletConfig().getServletName() + "." + name;
        String result = this.getServletConfig().getInitParameter(prefixedName);
        if (result == null) {
            result = this.getServletConfig().getServletContext().getInitParameter(prefixedName);
        }
        if (result == null && defaultValue != null) {
            result = defaultValue;
        }
        return result;
    }
}

