/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest;

import com.noelios.restlet.application.Encoder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.velocity.app.VelocityEngine;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.ContextException;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.Router;
import org.restlet.data.MediaType;
import org.slf4j.Logger;
import org.sonatype.plexus.rest.PlexusResourceFinder;
import org.sonatype.plexus.rest.RetargetableRestlet;
import org.sonatype.plexus.rest.resource.PlexusResource;
import org.sonatype.plexus.rest.xstream.json.JsonOrgHierarchicalStreamDriver;
import org.sonatype.plexus.rest.xstream.json.PrimitiveKeyedMapConverter;
import org.sonatype.plexus.rest.xstream.xml.LookAheadXppDriver;
import org.sonatype.sisu.goodies.common.Loggers;

public abstract class PlexusRestletApplicationBridge
extends Application {
    public static final String JSON_XSTREAM = "plexus.xstream.json";
    public static final String XML_XSTREAM = "plexus.xstream.xml";
    public static final String FILEITEM_FACTORY = "plexus.fileItemFactory";
    public static final String PLEXUS_DISCOVER_RESOURCES = "plexus.discoverResources";
    private static final String ENABLE_ENCODER_KEY = "enable-restlet-encoder";
    protected final Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass());
    private PlexusContainer plexusContainer;
    private Map<String, PlexusResource> plexusResources;
    private Provider<VelocityEngine> velocityEngineProvider;
    private ClassLoader uberClassLoader;
    private final Date createdOn = new Date();
    private RetargetableRestlet root;
    private Router rootRouter;
    private Router applicationRouter;

    @Inject
    public void installComponents(PlexusContainer plexusContainer, Map<String, PlexusResource> plexusResources, Provider<VelocityEngine> velocityEngineProvider, ClassLoader uberClassLoader) {
        this.plexusContainer = plexusContainer;
        this.plexusResources = plexusResources;
        this.velocityEngineProvider = velocityEngineProvider;
        this.uberClassLoader = uberClassLoader;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public final Restlet createRoot() {
        if (this.root == null) {
            this.root = new RetargetableRestlet(this.getContext());
        }
        this.configure();
        this.recreateRoot(true);
        this.setRoot(this.root);
        this.afterCreateRoot(this.root);
        return this.getRoot();
    }

    protected void afterCreateRoot(RetargetableRestlet root) {
    }

    protected Router getRootRouter() {
        return this.rootRouter;
    }

    protected Router getApplicationRouter() {
        return this.applicationRouter;
    }

    protected final void configure() {
        boolean shouldCollectPlexusResources;
        boolean bl = shouldCollectPlexusResources = this.getContext().getParameters().getFirstValue(PLEXUS_DISCOVER_RESOURCES) != null ? Boolean.parseBoolean(this.getContext().getParameters().getFirstValue(PLEXUS_DISCOVER_RESOURCES)) : true;
        if (shouldCollectPlexusResources) {
            this.logger.info("Discovered {} PlexusResource components", (Object)this.plexusResources.size());
        } else {
            this.plexusResources = new HashMap<String, PlexusResource>();
            this.logger.info("PlexusResource discovery disabled");
        }
        XStream xstream = this.createAndConfigureXstream(new JsonOrgHierarchicalStreamDriver());
        xstream.registerConverter((Converter)new PrimitiveKeyedMapConverter(xstream.getMapper()));
        this.getContext().getAttributes().put(JSON_XSTREAM, xstream);
        xstream = this.createAndConfigureXstream((HierarchicalStreamDriver)new LookAheadXppDriver());
        this.getContext().getAttributes().put(XML_XSTREAM, xstream);
        this.getContext().getAttributes().put(FILEITEM_FACTORY, new DiskFileItemFactory());
        this.getContext().getAttributes().put(VelocityEngine.class.getName(), this.velocityEngineProvider);
        this.doConfigure();
    }

    protected final void recreateRoot(boolean isStarted) {
        if (this.root != null) {
            this.rootRouter = new Router(this.getContext());
            this.applicationRouter = this.initializeRouter(this.rootRouter, isStarted);
            if (isStarted) {
                for (Map.Entry<String, PlexusResource> entry : this.plexusResources.entrySet()) {
                    try {
                        PlexusResource resource = entry.getValue();
                        this.attach(this.applicationRouter, resource);
                    }
                    catch (Exception e) {
                        this.logger.warn("Failed to attach resource: {}", (Object)entry.getKey(), (Object)e);
                    }
                }
            }
            this.doCreateRoot(this.rootRouter, isStarted);
            boolean enableCompression = false;
            try {
                if (this.plexusContainer.getContext().contains((Object)ENABLE_ENCODER_KEY) && Boolean.parseBoolean(this.plexusContainer.getContext().get((Object)ENABLE_ENCODER_KEY).toString())) {
                    enableCompression = true;
                    this.logger.debug("Restlet Encoder will compress output");
                }
            }
            catch (ContextException e) {
                this.logger.warn("Failed to get plexus property: {}, this property was found in the context", (Object)ENABLE_ENCODER_KEY, (Object)e);
            }
            ArrayList<MediaType> ignoredMediaTypes = new ArrayList<MediaType>(Encoder.getDefaultIgnoredMediaTypes());
            ignoredMediaTypes.add(MediaType.APPLICATION_COMPRESS);
            ignoredMediaTypes.add(new MediaType("application/x-bzip2"));
            ignoredMediaTypes.add(new MediaType("application/x-bzip"));
            ignoredMediaTypes.add(new MediaType("application/x-compressed"));
            ignoredMediaTypes.add(new MediaType("application/x-shockwave-flash"));
            Encoder encoder = new Encoder(this.getContext(), false, enableCompression, -1L, Encoder.getDefaultAcceptedMediaTypes(), ignoredMediaTypes);
            encoder.setNext((Restlet)this.rootRouter);
            this.root.setNext((Restlet)encoder);
        }
    }

    protected final XStream createAndConfigureXstream(HierarchicalStreamDriver driver) {
        XStream xstream = new XStream(driver);
        xstream.setClassLoader(this.uberClassLoader);
        xstream = this.doConfigureXstream(xstream);
        for (Map.Entry<String, PlexusResource> entry : this.plexusResources.entrySet()) {
            try {
                PlexusResource resource = entry.getValue();
                resource.configureXStream(xstream);
            }
            catch (Exception e) {
                this.logger.warn("Failed to configure xstream for resource: {}", (Object)entry.getKey(), (Object)e);
            }
        }
        return xstream;
    }

    protected void attach(Router router, boolean strict, String uriPattern, Restlet target) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Attaching Restlet of class '{}' to URI='{}' (strict='{}')", new Object[]{target.getClass().getName(), uriPattern, strict});
        }
        Route route = router.attach(uriPattern, target);
        if (strict) {
            route.getTemplate().setMatchingMode(2);
        } else {
            route.getTemplate().setMatchingMode(1);
        }
    }

    protected void attach(Router router, PlexusResource resource) {
        this.handlePlexusResourceSecurity(resource);
        this.attach(router, resource.requireStrictChecking(), resource.getResourceUri(), (Restlet)new PlexusResourceFinder(this.getContext(), resource));
    }

    protected void handlePlexusResourceSecurity(PlexusResource resource) {
    }

    protected void doConfigure() {
    }

    public XStream doConfigureXstream(XStream xstream) {
        return xstream;
    }

    protected Router initializeRouter(Router root, boolean isStarted) {
        return root;
    }

    protected void doCreateRoot(Router root, boolean isStarted) {
    }

    public synchronized void setRoot(RetargetableRestlet root) {
        this.root = root;
        super.setRoot((Restlet)root);
    }
}

