/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.sonatype.plexus.rest.PlexusContainerConfigurationUtils;
import org.sonatype.plexus.rest.PlexusContainerUtils;

public class PlexusContainerContextListener
implements ServletContextListener {
    private static final String KEY_PLEXUS = "plexus";
    PlexusContainerConfigurationUtils plexusContainerConfigurationUtils = new PlexusContainerConfigurationUtils();
    PlexusContainerUtils plexusContainerUtils = new PlexusContainerUtils();

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        ContainerConfiguration plexusContainerConfiguration = this.buildContainerConfiguration(context);
        try {
            this.initizlizePlexusContainer(context, plexusContainerConfiguration);
        }
        catch (PlexusContainerException e) {
            throw new IllegalStateException("Could start plexus container", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.plexusContainerUtils.stopContainer();
    }

    protected void initizlizePlexusContainer(ServletContext context, ContainerConfiguration configuration) throws PlexusContainerException {
        PlexusContainer plexusContainer = this.plexusContainerUtils.startContainer(configuration);
        context.setAttribute(KEY_PLEXUS, (Object)plexusContainer);
    }

    protected ContainerConfiguration buildContainerConfiguration(ServletContext context) {
        return this.plexusContainerConfigurationUtils.buildContainerConfiguration(context);
    }
}

