/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.StringUtils;

public class PlexusContainerConfigurationUtils {
    public static final String DEFAULT_PLEXUS_PROPERTIES = "/WEB-INF/plexus.properties";
    public static final String DEFAULT_PLEXUS_CONFIG = "/WEB-INF/plexus.xml";
    public static final String PLEXUS_HOME = "basedir";
    public static final String PLEXUS_PROPERTIES_PARAM = "plexus-properties";
    public static final String PLEXUS_CONFIG_PARAM = "plexus-config";

    public ContainerConfiguration buildContainerConfiguration(ServletContext servletContext) {
        ContainerConfiguration cc = new DefaultContainerConfiguration().setName(servletContext.getServletContextName()).setContainerConfigurationURL(this.buildConfigurationURL(servletContext)).setContext(this.buildContext(servletContext));
        return cc;
    }

    private Map<Object, Object> buildContext(ServletContext servletContext) {
        servletContext.log("Loading plexus context properties from: '/WEB-INF/plexus.properties'");
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        String plexusPropertiesPath = servletContext.getInitParameter(PLEXUS_PROPERTIES_PARAM);
        if (plexusPropertiesPath == null) {
            plexusPropertiesPath = DEFAULT_PLEXUS_PROPERTIES;
        }
        try {
            URL url = servletContext.getResource(plexusPropertiesPath);
            if (url == null && plexusPropertiesPath == DEFAULT_PLEXUS_PROPERTIES) {
                return context;
            }
            Properties properties = PropertyUtils.loadProperties((URL)url);
            if (properties == null) {
                throw new Exception("Could not locate url: " + url.toString());
            }
            String baseDir = servletContext.getRealPath("/WEB-INF");
            if (!StringUtils.isEmpty((String)baseDir)) {
                servletContext.log("Setting Plexus context variable basedir to: " + baseDir);
                properties.put(PLEXUS_HOME, baseDir);
            } else {
                servletContext.log("CANNOT set Plexus basedir! (are we in unpacked WAR?)");
            }
            RegexBasedInterpolator ip = new RegexBasedInterpolator();
            ip.addValueSource((ValueSource)new MapBasedValueSource((Map)properties));
            ip.addValueSource((ValueSource)new MapBasedValueSource((Map)System.getProperties()));
            Enumeration<?> n = properties.propertyNames();
            while (n.hasMoreElements()) {
                String propertyKey = (String)n.nextElement();
                String propertyValue = ip.interpolate(properties.getProperty(propertyKey), "");
                servletContext.log("Added '" + propertyKey + "=" + propertyValue + "' to Plexus context.");
                context.put(propertyKey, propertyValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load plexus context properties from: '" + plexusPropertiesPath + "'", e);
        }
        return context;
    }

    private URL buildConfigurationURL(ServletContext servletContext) {
        servletContext.log("Loading plexus configuration from: '/WEB-INF/plexus.xml'");
        String plexusConfigPath = servletContext.getInitParameter(PLEXUS_CONFIG_PARAM);
        if (plexusConfigPath == null) {
            plexusConfigPath = DEFAULT_PLEXUS_CONFIG;
        }
        try {
            URL url = servletContext.getResource(plexusConfigPath);
            return url;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load plexus configuration from: '" + plexusConfigPath + "'", e);
        }
    }
}

