/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest;

import org.codehaus.plexus.util.StringUtils;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.sonatype.plexus.rest.ReferenceFactory;

public class DefaultReferenceFactory
implements ReferenceFactory {
    @Override
    public Reference getContextRoot(Request request) {
        Reference result = request.getRootRef();
        if (StringUtils.isEmpty((String)result.getPath())) {
            result.setPath("/");
        }
        return result;
    }

    protected Reference updateBaseRefPath(Reference reference) {
        if (reference.getBaseRef().getPath() == null) {
            reference.getBaseRef().setPath("/");
        } else if (!reference.getBaseRef().getPath().endsWith("/")) {
            reference.getBaseRef().setPath(reference.getBaseRef().getPath() + "/");
        }
        return reference;
    }

    @Override
    public Reference createThisReference(Request request) {
        String uriPart = request.getResourceRef().getTargetRef().toString().substring(request.getRootRef().getTargetRef().toString().length());
        if (uriPart.startsWith("/")) {
            uriPart = uriPart.substring(1);
        }
        return this.updateBaseRefPath(new Reference(this.getContextRoot(request), uriPart));
    }

    @Override
    public Reference createChildReference(Request request, String childPath) {
        Reference result = this.createThisReference(request).addSegment(childPath);
        if (result.hasQuery()) {
            result.setQuery(null);
        }
        return result.getTargetRef();
    }

    @Override
    public Reference createReference(Reference base, String relPart) {
        Reference ref = new Reference(base, relPart);
        return this.updateBaseRefPath(ref).getTargetRef();
    }

    @Override
    public Reference createReference(Request base, String relPart) {
        return this.createReference(this.getContextRoot(base), relPart);
    }
}

