/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

@JRubyClass(name={"Exception"})
public class RubyException
extends RubyObject {
    public static ObjectAllocator EXCEPTION_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyException instance = new RubyException(runtime, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };
    private static final ObjectMarshal EXCEPTION_MARSHAL = new ObjectMarshal(){

        @Override
        public void marshalTo(Ruby runtime, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            RubyException exc = (RubyException)obj;
            marshalStream.registerLinkTarget(exc);
            List<Variable<Object>> attrs = exc.getVariableList();
            attrs.add(new VariableEntry<IRubyObject>("mesg", exc.message == null ? runtime.getNil() : exc.message));
            attrs.add(new VariableEntry<IRubyObject>("bt", exc.getBacktrace()));
            marshalStream.dumpVariables(attrs);
        }

        @Override
        public Object unmarshalFrom(Ruby runtime, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            RubyException exc = (RubyException)type2.allocate();
            unmarshalStream.registerLinkTarget(exc);
            unmarshalStream.defaultVariablesUnmarshal(exc);
            exc.message = (IRubyObject)exc.removeInternalVariable("mesg");
            exc.set_backtrace((IRubyObject)exc.removeInternalVariable("bt"));
            return exc;
        }
    };
    private BacktraceData backtraceData;
    private IRubyObject backtrace;
    public IRubyObject message;
    public static final int TRACE_HEAD = 8;
    public static final int TRACE_TAIL = 4;
    public static final int TRACE_MAX = 18;

    protected RubyException(Ruby runtime, RubyClass rubyClass) {
        this(runtime, rubyClass, null);
    }

    public RubyException(Ruby runtime, RubyClass rubyClass, String message2) {
        super(runtime, rubyClass);
        this.message = message2 == null ? runtime.getNil() : runtime.newString(message2);
    }

    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        if (args2.length == 1) {
            this.message = args2[0];
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject backtrace() {
        IRubyObject bt = this.getBacktrace();
        return bt;
    }

    @JRubyMethod(required=1)
    public IRubyObject set_backtrace(IRubyObject obj) {
        if (obj.isNil()) {
            this.backtrace = null;
        } else if (this.isArrayOfStrings(obj)) {
            this.backtrace = obj;
        } else if (obj instanceof RubyString) {
            this.backtrace = RubyArray.newArray(this.getRuntime(), obj);
        } else {
            throw this.getRuntime().newTypeError("backtrace must be Array of String or a single String");
        }
        return this.backtrace();
    }

    @JRubyMethod(compat=CompatVersion.RUBY2_0, omit=true)
    public IRubyObject backtrace_locations(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyStackTraceElement[] elements = this.backtraceData.getBacktrace(runtime);
        return RubyThread.Location.newLocationArray(runtime, elements);
    }

    @JRubyMethod(name={"exception"}, optional=1, rest=true, meta=true)
    public static IRubyObject exception(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return ((RubyClass)recv2).newInstance(context, args2, block);
    }

    @JRubyMethod(optional=1)
    public RubyException exception(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this;
            }
            case 1: {
                if (args2[0] == this) {
                    return this;
                }
                RubyException ret = (RubyException)this.rbClone();
                ret.initialize(args2, Block.NULL_BLOCK);
                return ret;
            }
        }
        throw this.getRuntime().newArgumentError("Wrong argument count");
    }

    @JRubyMethod(name={"to_s"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_s(ThreadContext context) {
        if (this.message.isNil()) {
            return context.runtime.newString(this.getMetaClass().getRealClass().getName());
        }
        this.message.setTaint(this.isTaint());
        return this.message;
    }

    @JRubyMethod(name={"to_s"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_s19(ThreadContext context) {
        if (this.message.isNil()) {
            return context.runtime.newString(this.getMetaClass().getRealClass().getName());
        }
        this.message.setTaint(this.isTaint());
        return this.message.asString();
    }

    @JRubyMethod(name={"to_str"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_str(ThreadContext context) {
        return this.callMethod(context, "to_s");
    }

    @JRubyMethod(name={"message"})
    public IRubyObject message(ThreadContext context) {
        return this.callMethod(context, "to_s");
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        RubyClass rubyClass = this.getMetaClass().getRealClass();
        RubyString exception2 = RubyString.objAsString(context, this);
        if (exception2.size() == 0) {
            return this.getRuntime().newString(rubyClass.getName());
        }
        StringBuilder sb = new StringBuilder("#<");
        sb.append(rubyClass.getName()).append(": ").append((CharSequence)exception2.getByteList()).append(">");
        return this.getRuntime().newString(sb.toString());
    }

    @Override
    @JRubyMethod(name={"=="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        boolean equal;
        if (this == other) {
            return context.runtime.getTrue();
        }
        boolean bl = equal = context.runtime.getException().isInstance(other) && this.callMethod(context, "message").equals(other.callMethod(context, "message")) && this.callMethod(context, "backtrace").equals(other.callMethod(context, "backtrace"));
        if (context.runtime.is2_0()) {
            equal = equal && this.getMetaClass().getRealClass() == other.getMetaClass().getRealClass();
        }
        return context.runtime.newBoolean(equal);
    }

    @JRubyMethod(name={"==="}, meta=true)
    public static IRubyObject op_eqq(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        Object object;
        Ruby runtime = context.runtime;
        if (other instanceof ConcreteJavaProxy && (recv2 == runtime.getException() || recv2 == runtime.getStandardError()) && (object = ((ConcreteJavaProxy)other).getObject()) instanceof Throwable && !(object instanceof JumpException.FlowControlException) && (recv2 == runtime.getException() || object instanceof Exception)) {
            return context.runtime.getTrue();
        }
        return ((RubyClass)recv2).op_eqq(context, other);
    }

    public void setBacktraceData(BacktraceData backtraceData) {
        this.backtraceData = backtraceData;
    }

    public BacktraceData getBacktraceData() {
        return this.backtraceData;
    }

    public RubyStackTraceElement[] getBacktraceElements() {
        if (this.backtraceData == null) {
            return RubyStackTraceElement.EMPTY_ARRAY;
        }
        return this.backtraceData.getBacktrace(this.getRuntime());
    }

    public void prepareBacktrace(ThreadContext context, boolean nativeException) {
        if (this.backtraceData == null) {
            this.backtraceData = context.runtime.getInstanceConfig().getTraceType().getBacktrace(context, nativeException);
        }
    }

    public void prepareIntegratedBacktrace(ThreadContext context, StackTraceElement[] javaTrace) {
        if (this.backtraceData == null) {
            this.backtraceData = context.runtime.getInstanceConfig().getTraceType().getIntegratedBacktrace(context, javaTrace);
        }
    }

    public void forceBacktrace(IRubyObject backtrace2) {
        this.backtraceData = BacktraceData.EMPTY;
        this.set_backtrace(backtrace2);
    }

    public IRubyObject getBacktrace() {
        if (this.backtrace == null) {
            this.initBacktrace();
        }
        return this.backtrace;
    }

    public void initBacktrace() {
        Ruby runtime = this.getRuntime();
        this.backtrace = this.backtraceData == null ? runtime.getNil() : TraceType.generateMRIBacktrace(runtime, this.backtraceData.getBacktrace(runtime));
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone) {
        RubyException exception2 = (RubyException)clone;
        exception2.backtraceData = this.backtraceData;
        exception2.backtrace = this.backtrace;
        exception2.message = this.message;
    }

    public void printBacktrace(PrintStream errorStream) {
        this.printBacktrace(errorStream, 0);
    }

    public void printBacktrace(PrintStream errorStream, int skip2) {
        IRubyObject backtrace2 = this.callMethod(this.getRuntime().getCurrentContext(), "backtrace");
        if (!backtrace2.isNil() && backtrace2 instanceof RubyArray) {
            IRubyObject[] elements = backtrace2.convertToArray().toJavaArray();
            for (int i2 = skip2; i2 < elements.length; ++i2) {
                IRubyObject stackTraceLine = elements[i2];
                if (!(stackTraceLine instanceof RubyString)) continue;
                this.printStackTraceLine(errorStream, stackTraceLine);
            }
        }
    }

    private void printStackTraceLine(PrintStream errorStream, IRubyObject stackTraceLine) {
        errorStream.print("\tfrom " + stackTraceLine + '\n');
    }

    private boolean isArrayOfStrings(IRubyObject backtrace2) {
        if (!(backtrace2 instanceof RubyArray)) {
            return false;
        }
        IRubyObject[] elements = ((RubyArray)backtrace2).toJavaArray();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            if (elements[i2] instanceof RubyString) continue;
            return false;
        }
        return true;
    }

    public static RubyClass createExceptionClass(Ruby runtime) {
        RubyClass exceptionClass = runtime.defineClass("Exception", runtime.getObject(), EXCEPTION_ALLOCATOR);
        runtime.setException(exceptionClass);
        exceptionClass.index = 30;
        exceptionClass.setReifiedClass(RubyException.class);
        exceptionClass.setMarshal(EXCEPTION_MARSHAL);
        exceptionClass.defineAnnotatedMethods(RubyException.class);
        return exceptionClass;
    }

    public static RubyException newException(Ruby runtime, RubyClass excptnClass, String msg) {
        return new RubyException(runtime, excptnClass, msg);
    }

    public static IRubyObject newException(ThreadContext context, RubyClass exceptionClass, IRubyObject message2) {
        return exceptionClass.callMethod(context, "new", (IRubyObject)message2.convertToString());
    }
}

