/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.locks;

import java.util.ArrayList;
import java.util.Arrays;
import org.sonatype.sisu.locks.AbstractResourceLockMBean;
import org.sonatype.sisu.locks.ResourceLock;
import org.sonatype.sisu.locks.ResourceLockFactory;

final class LocalResourceLockMBean
extends AbstractResourceLockMBean {
    private final ResourceLockFactory locks;

    LocalResourceLockMBean(ResourceLockFactory locks) {
        this.locks = locks;
    }

    @Override
    public String[] listResourceNames() {
        return this.locks.getResourceNames();
    }

    @Override
    public String[] findOwningThreads(String name) {
        if (!Arrays.asList(this.locks.getResourceNames()).contains(name)) {
            return new String[0];
        }
        Thread[] owners = this.locks.getResourceLock(name).getOwners();
        String[] ownerTIDs = new String[owners.length];
        for (int i = 0; i < owners.length; ++i) {
            ownerTIDs[i] = Long.toString(owners[i].getId());
        }
        return ownerTIDs;
    }

    @Override
    public String[] findWaitingThreads(String name) {
        if (!Arrays.asList(this.locks.getResourceNames()).contains(name)) {
            return new String[0];
        }
        Thread[] waiters = this.locks.getResourceLock(name).getWaiters();
        String[] waiterTIDs = new String[waiters.length];
        for (int i = 0; i < waiters.length; ++i) {
            waiterTIDs[i] = Long.toString(waiters[i].getId());
        }
        return waiterTIDs;
    }

    @Override
    public String[] findOwnedResources(String tid) {
        long ownerId = Long.decode(tid);
        ArrayList<String> names = new ArrayList<String>();
        for (String n : this.locks.getResourceNames()) {
            for (Thread t : this.locks.getResourceLock(n).getOwners()) {
                if (t.getId() != ownerId) continue;
                names.add(n);
            }
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public String[] findWaitedResources(String tid) {
        long waiterId = Long.decode(tid);
        ArrayList<String> names = new ArrayList<String>();
        for (String n : this.locks.getResourceNames()) {
            for (Thread t : this.locks.getResourceLock(n).getWaiters()) {
                if (t.getId() != waiterId) continue;
                names.add(n);
            }
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public void releaseResource(String name) {
        if (Arrays.asList(this.locks.getResourceNames()).contains(name)) {
            ResourceLock lock = this.locks.getResourceLock(name);
            for (Thread t : lock.getOwners()) {
                int i;
                for (i = lock.getSharedCount(t); i > 0; --i) {
                    lock.unlockShared(t);
                }
                for (i = lock.getExclusiveCount(t); i > 0; --i) {
                    lock.unlockExclusive(t);
                }
            }
        }
    }
}

