/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.locks;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiTask;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.management.ObjectName;
import org.eclipse.sisu.inject.Logs;
import org.sonatype.sisu.locks.AbstractResourceLockMBean;
import org.sonatype.sisu.locks.HazelcastMBeansInvoker;

final class HazelcastResourceLockMBean
extends AbstractResourceLockMBean {
    private final HazelcastInstance instance;
    private final ObjectName jmxQuery;

    HazelcastResourceLockMBean(HazelcastInstance instance, ObjectName jmxQuery) {
        this.instance = instance;
        this.jmxQuery = jmxQuery;
    }

    @Override
    public String[] listResourceNames() {
        return this.multiInvoke("listResourceNames", new String[0]);
    }

    @Override
    public String[] findOwningThreads(String name) {
        return this.multiInvoke("findOwningThreads", name);
    }

    @Override
    public String[] findWaitingThreads(String name) {
        return this.multiInvoke("findWaitingThreads", name);
    }

    @Override
    public String[] findOwnedResources(String tid) {
        return this.multiInvoke("findOwnedResources", tid);
    }

    @Override
    public String[] findWaitedResources(String tid) {
        return this.multiInvoke("findWaitedResources", tid);
    }

    @Override
    public void releaseResource(String name) {
        this.multiInvoke("releaseResource", name);
    }

    public String[] multiInvoke(String method, String ... args) {
        HazelcastMBeansInvoker invoker = new HazelcastMBeansInvoker(this.jmxQuery, method, args);
        MultiTask task = new MultiTask((Callable)invoker, this.filterMembers(method, args));
        HashSet results = new HashSet();
        try {
            this.instance.getExecutorService().execute((Runnable)task);
            for (List result : task.get()) {
                results.addAll(result);
            }
        }
        catch (Exception e) {
            Logs.warn((String)"Problem executing cluster MultiTask for: \"{}\"", (Object)method, (Object)e);
        }
        return results.toArray(new String[results.size()]);
    }

    private Set<Member> filterMembers(String method, String ... args) {
        HashSet<Member> members = new HashSet<Member>();
        try {
            if (method.endsWith("Resources") && args[0].contains("@")) {
                String[] tokens = args[0].split("\\s*[@:]\\s*", 3);
                args[0] = tokens[0];
                if (tokens.length == 3) {
                    InetSocketAddress addr = new InetSocketAddress(tokens[1], Integer.parseInt(tokens[2]));
                    for (Member m : this.instance.getCluster().getMembers()) {
                        if (!addr.equals(m.getInetSocketAddress())) continue;
                        members.add(m);
                    }
                } else if (tokens.length == 2) {
                    InetAddress addr = InetAddress.getByName(tokens[1]);
                    for (Member m : this.instance.getCluster().getMembers()) {
                        if (!addr.equals(m.getInetSocketAddress().getAddress())) continue;
                        members.add(m);
                    }
                }
            }
        }
        catch (Exception e) {
            Logs.warn((String)"Problem filtering cluster members for: \"{}\"", (Object)method, (Object)e);
        }
        if (members.isEmpty()) {
            members.addAll(this.instance.getCluster().getMembers());
        }
        return members;
    }
}

