/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.locks;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.management.ManagementFactory;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.sisu.inject.Logs;
import org.sonatype.sisu.locks.AbstractResourceLockFactory;
import org.sonatype.sisu.locks.HazelcastResourceLock;
import org.sonatype.sisu.locks.HazelcastResourceLockMBean;
import org.sonatype.sisu.locks.ResourceLock;

@Named(value="hazelcast")
@Singleton
final class HazelcastResourceLockFactory
extends AbstractResourceLockFactory {
    private final HazelcastInstance instance;
    private ObjectName jmxQuery;
    private ObjectName jmxMaster;

    @Inject
    HazelcastResourceLockFactory(@Nullable @Named(value="hazelcast.config") File configFile) {
        super(true);
        this.instance = Hazelcast.newHazelcastInstance((Config)HazelcastResourceLockFactory.getHazelcastConfig(configFile));
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            this.jmxMaster = ObjectName.getInstance("org.sonatype.sisu", "type", this.category());
            this.jmxQuery = ObjectName.getInstance("org.sonatype.sisu", HazelcastResourceLockFactory.properties("type", this.category(), "hash", "*"));
            if (!server.isRegistered(this.jmxMaster)) {
                server.registerMBean(new HazelcastResourceLockMBean(this.instance, this.jmxQuery), this.jmxMaster);
            }
        }
        catch (Exception e) {
            Logs.warn((String)"Problem registering master LocksMBean for: <>", (Object)this, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        boolean lastMember = false;
        try {
            super.shutdown();
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            lastMember = server.queryNames(this.jmxQuery, null).isEmpty();
            if (lastMember) {
                try {
                    server.unregisterMBean(this.jmxMaster);
                }
                catch (Exception e) {
                    Logs.warn((String)"Problem unregistering master LocksMBean for: <>", (Object)this, (Object)e);
                }
            }
        }
        finally {
            if (lastMember) {
                Hazelcast.shutdownAll();
            } else {
                this.instance.getLifecycleService().shutdown();
            }
        }
    }

    @Override
    protected String category() {
        return HazelcastResourceLock.class.getSimpleName() + 's';
    }

    @Override
    protected ResourceLock createResourceLock(String name) {
        return new HazelcastResourceLock(this.instance.getSemaphore(name));
    }

    private static Config getHazelcastConfig(File configFile) {
        Config config;
        if (null != configFile && configFile.isFile()) {
            try {
                config = new FileSystemXmlConfig(configFile);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            config = new XmlConfigBuilder().build();
        }
        config.getSemaphoreConfig("default").setInitialPermits(Integer.MAX_VALUE);
        config.setClassLoader(Hazelcast.class.getClassLoader());
        return config;
    }
}

