/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.locks;

import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.InstanceDestroyedException;
import org.sonatype.sisu.locks.AbstractSemaphoreResourceLock;

final class HazelcastResourceLock
extends AbstractSemaphoreResourceLock {
    private final ISemaphore sem;

    HazelcastResourceLock(ISemaphore sem) {
        this.sem = sem;
    }

    /*
     * Loose catch block
     */
    @Override
    protected void acquire(int permits) {
        while (true) {
            try {
                this.sem.acquireAttach(permits);
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        catch (InstanceDestroyedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void release(int permits) {
        this.sem.releaseDetach(permits);
    }

    @Override
    protected int availablePermits() {
        return this.sem.availablePermits();
    }
}

