/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.locks;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.sisu.inject.Logs;

final class HazelcastMBeansInvoker
implements HazelcastInstanceAware,
Callable<List<String>>,
Serializable {
    private HazelcastInstance instance;
    private final ObjectName jmxQuery;
    private final String method;
    private final String[] args;

    HazelcastMBeansInvoker(ObjectName jmxQuery, String method, String ... args) {
        this.jmxQuery = jmxQuery;
        this.method = method;
        this.args = args;
    }

    public void setHazelcastInstance(HazelcastInstance instance) {
        this.instance = instance;
    }

    @Override
    public List<String> call() throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Object[] sig = new String[this.args.length];
        Arrays.fill(sig, String.class.getName());
        ArrayList<String> results = new ArrayList<String>();
        for (ObjectName mBean : server.queryNames(this.jmxQuery, null)) {
            try {
                Object result = server.invoke(mBean, this.method, this.args, (String[])sig);
                if (!(result instanceof String[])) continue;
                Collections.addAll(results, (String[])result);
            }
            catch (Exception e) {
                Logs.warn((String)"Problem invoking JMX method: \"{}\"", (Object)this.method, (Object)e);
            }
        }
        return this.qualifyResults(results);
    }

    private List<String> qualifyResults(List<String> results) {
        if (this.method.endsWith("Threads")) {
            String addr = HazelcastMBeansInvoker.toString(this.instance.getCluster().getLocalMember().getInetSocketAddress());
            for (int i = 0; i < results.size(); ++i) {
                results.set(i, results.get(i) + " @ " + addr);
            }
        }
        return results;
    }

    private static String toString(InetSocketAddress address) {
        StringBuilder buf = new StringBuilder();
        byte[] ip = address.getAddress().getAddress();
        HazelcastMBeansInvoker.append(buf, ip[0], '.');
        HazelcastMBeansInvoker.append(buf, ip[1], '.');
        HazelcastMBeansInvoker.append(buf, ip[2], '.');
        HazelcastMBeansInvoker.append(buf, ip[3], ':');
        return buf.append(address.getPort()).toString();
    }

    private static void append(StringBuilder buf, byte value, char delim) {
        buf.append(value & 0xFF).append(delim);
    }
}

