/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.locks;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sonatype.sisu.locks.ResourceLock;

public abstract class AbstractSemaphoreResourceLock
implements ResourceLock {
    private static final int SHARED = 0;
    private static final int EXCLUSIVE = 1;
    private final Map<Thread, int[]> map = new ConcurrentHashMap<Thread, int[]>(16, 0.75f, 1);

    @Override
    public final void lockShared(Thread thread) {
        int[] counters = this.map.get(thread);
        if (null == counters) {
            counters = new int[]{0, 0};
            this.map.put(thread, counters);
            this.acquire(1);
        }
        counters[0] = counters[0] + 1;
    }

    @Override
    public final void lockExclusive(Thread thread) {
        int[] counters = this.map.get(thread);
        if (null == counters) {
            counters = new int[]{0, 0};
            this.map.put(thread, counters);
            this.acquire(Integer.MAX_VALUE);
        } else if (counters[1] == 0) {
            int shared = counters[0];
            this.release(1);
            counters[0] = 0;
            this.acquire(Integer.MAX_VALUE);
            counters[0] = shared;
        }
        counters[1] = counters[1] + 1;
    }

    @Override
    public final void unlockExclusive(Thread thread) {
        int[] counters = this.map.get(thread);
        if (null != counters && counters[1] > 0) {
            counters[1] = counters[1] - 1;
            if (counters[1] == 0) {
                this.release(Integer.MAX_VALUE);
                int shared = counters[0];
                if (shared > 0) {
                    counters[0] = 0;
                    this.acquire(1);
                    counters[0] = shared;
                } else {
                    this.map.remove(thread);
                }
            }
        } else {
            throw new IllegalStateException(thread + " does not hold this resource");
        }
    }

    @Override
    public final void unlockShared(Thread thread) {
        int[] counters = this.map.get(thread);
        if (null != counters && counters[0] > 0) {
            counters[0] = counters[0] - 1;
            if (counters[0] == 0 && counters[1] == 0) {
                this.release(1);
                this.map.remove(thread);
            }
        } else {
            throw new IllegalStateException(thread + " does not hold this resource");
        }
    }

    @Override
    public final Thread[] getOwners() {
        ArrayList<Thread> owners = new ArrayList<Thread>();
        for (Map.Entry<Thread, int[]> e : this.map.entrySet()) {
            int[] counters = e.getValue();
            if (counters[0] <= 0 && counters[1] <= 0) continue;
            owners.add(e.getKey());
        }
        return owners.toArray(new Thread[owners.size()]);
    }

    @Override
    public final Thread[] getWaiters() {
        ArrayList<Thread> waiters = new ArrayList<Thread>();
        for (Map.Entry<Thread, int[]> e : this.map.entrySet()) {
            int[] counters = e.getValue();
            if (counters[0] != 0 || counters[1] != 0) continue;
            waiters.add(e.getKey());
        }
        return waiters.toArray(new Thread[waiters.size()]);
    }

    @Override
    public final int getSharedCount(Thread thread) {
        int[] counters = this.map.get(thread);
        return null != counters ? counters[0] : 0;
    }

    @Override
    public final int getExclusiveCount(Thread thread) {
        int[] counters = this.map.get(thread);
        return null != counters ? counters[1] : 0;
    }

    public String toString() {
        int permits = this.availablePermits();
        int owners = permits > 0 ? Integer.MAX_VALUE - permits : 1;
        return "[Owners = " + owners + ", Exclusive = " + (permits == 0) + "]";
    }

    protected abstract void acquire(int var1);

    protected abstract void release(int var1);

    protected abstract int availablePermits();
}

