/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.locks;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.Weak;
import org.sonatype.sisu.locks.LocalResourceLockMBean;
import org.sonatype.sisu.locks.ResourceLock;
import org.sonatype.sisu.locks.ResourceLockFactory;

abstract class AbstractResourceLockFactory
implements ResourceLockFactory {
    protected static final String JMX_DOMAIN = "org.sonatype.sisu";
    private final ConcurrentMap<String, ResourceLock> resourceLocks = Weak.concurrentValues();
    private ObjectName jmxName;

    AbstractResourceLockFactory(boolean jmxEnabled) {
        if (jmxEnabled) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                String hash = String.format("0x%08X", new Integer(System.identityHashCode(this)));
                this.jmxName = ObjectName.getInstance(JMX_DOMAIN, AbstractResourceLockFactory.properties("type", this.category(), "hash", hash));
                server.registerMBean(new LocalResourceLockMBean(this), this.jmxName);
            }
            catch (Exception e) {
                Logs.warn((String)"Problem registering LocksMBean for: <>", (Object)this, (Object)e);
            }
        }
    }

    @Override
    public final ResourceLock getResourceLock(String name) {
        ResourceLock oldLock;
        ResourceLock lock = (ResourceLock)this.resourceLocks.get(name);
        if (null == lock && null != (oldLock = this.resourceLocks.putIfAbsent(name, lock = this.createResourceLock(name)))) {
            return oldLock;
        }
        return lock;
    }

    @Override
    public final String[] getResourceNames() {
        return this.resourceLocks.keySet().toArray(new String[0]);
    }

    @Override
    public void shutdown() {
        if (null != this.jmxName) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.jmxName);
            }
            catch (Exception e) {
                Logs.warn((String)"Problem unregistering LocksMBean for: <>", (Object)this, (Object)e);
            }
        }
    }

    protected abstract String category();

    protected abstract ResourceLock createResourceLock(String var1);

    protected static final Hashtable<String, String> properties(String ... keyValues) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        int i = 0;
        while (i < keyValues.length) {
            properties.put(keyValues[i++], keyValues[i++]);
        }
        return properties;
    }
}

