/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.content.internal.ContentRenderer;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.RequestContext;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.attributes.Attributes;
import org.sonatype.nexus.proxy.attributes.internal.DefaultAttributes;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageCompositeItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.uid.IsHiddenAttribute;
import org.sonatype.nexus.proxy.repository.GroupItemNotFoundException;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.web.BaseUrlHolder;
import org.sonatype.nexus.web.TemplateRenderer;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class VelocityContentRenderer
extends ComponentSupport
implements ContentRenderer {
    private final TemplateRenderer templateRenderer;
    private final String applicationVersion;

    @Inject
    public VelocityContentRenderer(TemplateRenderer templateRenderer, ApplicationStatusSource applicationStatusSource) {
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer);
        this.applicationVersion = ((ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource)).getSystemStatus().getVersion();
    }

    @Override
    public void renderCollection(HttpServletRequest request, HttpServletResponse response, StorageCollectionItem coll, Collection<StorageItem> children) throws IOException {
        HashSet uniqueNames = Sets.newHashSetWithExpectedSize((int)children.size());
        ArrayList entries = Lists.newArrayListWithCapacity((int)children.size());
        String collUrl = BaseUrlHolder.get() + request.getServletPath() + request.getPathInfo();
        for (StorageItem child : children) {
            if (!child.isVirtual() && child.getRepositoryItemUid().getBooleanAttributeValue(IsHiddenAttribute.class) || uniqueNames.contains(child.getName())) continue;
            boolean isCollection = child instanceof StorageCollectionItem;
            String name = isCollection ? child.getName() + "/" : child.getName();
            CollectionEntry entry = new CollectionEntry(name, isCollection, collUrl + name, new Date(child.getModified()), StorageFileItem.class.isAssignableFrom(child.getClass()) ? ((StorageFileItem)child).getLength() : -1L, "");
            entries.add(entry);
            uniqueNames.add(child.getName());
        }
        Collections.sort(entries, new CollectionEntryComparator());
        Map<String, Object> dataModel = this.createBaseModel();
        dataModel.put("requestPath", coll.getPath());
        dataModel.put("listItems", entries);
        this.templateRenderer.render(this.templateRenderer.template("/org/sonatype/nexus/content/internal/repositoryContentHtml.vm", this.getClass().getClassLoader()), dataModel, response);
    }

    @Override
    public void renderRequestDescription(HttpServletRequest request, HttpServletResponse response, ResourceStoreRequest resourceStoreRequest, StorageItem item, Exception exception) throws IOException {
        Map<String, Object> dataModel = this.createBaseModel();
        dataModel.put("req", resourceStoreRequest);
        if (item != null) {
            dataModel.put("item", item);
            dataModel.put("itemContext", this.filterItemContext(item.getItemContext()).flatten());
            dataModel.put("itemAttributes", this.filterItemAttributes(item.getRepositoryItemAttributes()).asMap());
            if (item instanceof StorageCompositeItem) {
                StorageCompositeItem compositeItem = (StorageCompositeItem)item;
                ArrayList sources = Lists.newArrayList();
                for (StorageItem source : compositeItem.getSources()) {
                    if (!source.isVirtual()) {
                        sources.add(source.getRepositoryItemUid().toString());
                        continue;
                    }
                    sources.add(source.getPath());
                }
                dataModel.put("compositeSources", sources);
            }
        }
        dataModel.put("exception", exception);
        Reasoning reasoning = this.buildReasoning(exception);
        if (reasoning != null) {
            dataModel.put("reasoning", reasoning);
        }
        this.templateRenderer.render(this.templateRenderer.template("/org/sonatype/nexus/content/internal/requestDescriptionHtml.vm", this.getClass().getClassLoader()), dataModel, response);
    }

    private RequestContext filterItemContext(RequestContext itemContext) {
        RequestContext filtered = new RequestContext();
        filtered.setParentContext(itemContext);
        return filtered;
    }

    private Attributes filterItemAttributes(Attributes itemAttributes) {
        int qpIdx;
        DefaultAttributes filtered = new DefaultAttributes();
        filtered.overlayAttributes(itemAttributes);
        String remoteUrl = filtered.get("storageItem-remoteUrl");
        if (remoteUrl != null && remoteUrl.startsWith("https://secure.central.sonatype.com/") && (qpIdx = remoteUrl.indexOf("?")) > -1) {
            filtered.setRemoteUrl(remoteUrl.substring(0, qpIdx) + "?truncated");
        }
        return filtered;
    }

    private Reasoning buildReasoning(Throwable ex) {
        ItemNotFoundException.ItemNotFoundReason reason;
        if (ex instanceof ItemNotFoundException && (reason = ((ItemNotFoundException)ex).getReason()) instanceof ItemNotFoundException.ItemNotFoundInRepositoryReason) {
            return this.buildReasoning(((ItemNotFoundException.ItemNotFoundInRepositoryReason)reason).getRepository().getId(), ex);
        }
        return null;
    }

    private Reasoning buildReasoning(String repositoryId, Throwable ex) {
        Reasoning result = new Reasoning(repositoryId, ex.getMessage());
        if (ex instanceof GroupItemNotFoundException) {
            GroupItemNotFoundException ginfex = (GroupItemNotFoundException)ex;
            for (Map.Entry memberReason : ginfex.getMemberReasons().entrySet()) {
                result.getMembers().add(this.buildReasoning(((Repository)memberReason.getKey()).getId(), (Throwable)memberReason.getValue()));
            }
        }
        return result;
    }

    private Map<String, Object> createBaseModel() {
        HashMap dataModel = Maps.newHashMap();
        dataModel.put("nexusRoot", BaseUrlHolder.get());
        dataModel.put("nexusVersion", this.applicationVersion);
        return dataModel;
    }

    public static class CollectionEntry {
        private final String name;
        private final boolean collection;
        private final String resourceUri;
        private final Date lastModified;
        private final long size;
        private final String description;

        public CollectionEntry(String name, boolean collection, String resourceUri, Date lastModified, long size, String description) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.collection = collection;
            this.resourceUri = (String)Preconditions.checkNotNull((Object)resourceUri);
            this.lastModified = (Date)Preconditions.checkNotNull((Object)lastModified);
            this.size = size;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public boolean isCollection() {
            return this.collection;
        }

        public String getResourceUri() {
            return this.resourceUri;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public long getSize() {
            return this.size;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class CollectionEntryComparator
    implements Comparator<CollectionEntry> {
        private CollectionEntryComparator() {
        }

        @Override
        public int compare(CollectionEntry o1, CollectionEntry o2) {
            if (o1.isCollection()) {
                if (o2.isCollection()) {
                    return o1.getName().compareTo(o2.getName());
                }
                return -1;
            }
            if (o2.isCollection()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class Reasoning {
        private final String repositoryId;
        private final String reason;
        private final List<Reasoning> members;

        public Reasoning(String repositoryId, String reason) {
            this.repositoryId = (String)Preconditions.checkNotNull((Object)repositoryId);
            this.reason = (String)Preconditions.checkNotNull((Object)reason);
            this.members = Lists.newArrayList();
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }

        public String getReason() {
            return this.reason;
        }

        public List<Reasoning> getMembers() {
            return this.members;
        }
    }
}

