/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.content.internal.ContentRenderer;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.IllegalRequestException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageEOFException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.NoSuchResourceStoreException;
import org.sonatype.nexus.proxy.RemoteStorageTransportOverloadedException;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StorageLinkItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.router.RepositoryRouter;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.nexus.web.BaseUrlHolder;
import org.sonatype.nexus.web.ErrorStatusException;
import org.sonatype.nexus.web.RemoteIPFinder;
import org.sonatype.nexus.web.WebUtils;
import org.sonatype.sisu.goodies.common.Throwables2;

@Singleton
@Named
public class ContentServlet
extends HttpServlet {
    private static final String REQ_QP_DESCRIBE_PARAMETER = "describe";
    private static final String REQ_QP_FORCE_PARAMETER = "force";
    private static final String REQ_QP_FORCE_LOCAL_VALUE = "local";
    private static final String REQ_QP_FORCE_REMOTE_VALUE = "remote";
    private static final String REQ_QP_FORCE_EXPIRED_VALUE = "expired";
    private static final boolean DEREFERENCE_LINKS = SystemPropertiesHelper.getBoolean((String)(ContentServlet.class.getName() + ".DEREFERENCE_LINKS"), (boolean)true);
    private static final String STOPWATCH_KEY = ContentServlet.class.getName() + ".stopwatch";
    private final Logger logger = LoggerFactory.getLogger(ContentServlet.class);
    private final NexusConfiguration nexusConfiguration;
    private final RepositoryRouter repositoryRouter;
    private final ContentRenderer contentRenderer;
    private final WebUtils webUtils;

    @Inject
    public ContentServlet(NexusConfiguration nexusConfiguration, RepositoryRouter repositoryRouter, ContentRenderer contentRenderer, WebUtils webUtils) {
        this.nexusConfiguration = (NexusConfiguration)Preconditions.checkNotNull((Object)nexusConfiguration);
        this.repositoryRouter = (RepositoryRouter)Preconditions.checkNotNull((Object)repositoryRouter);
        this.contentRenderer = (ContentRenderer)Preconditions.checkNotNull((Object)contentRenderer);
        this.webUtils = (WebUtils)Preconditions.checkNotNull((Object)webUtils);
        this.logger.debug("dereferenceLinks={}", (Object)DEREFERENCE_LINKS);
    }

    protected ResourceStoreRequest getResourceStoreRequest(HttpServletRequest request) {
        String ifNoneMatch;
        String resourceStorePath = request.getPathInfo();
        if (Strings.isNullOrEmpty((String)resourceStorePath)) {
            resourceStorePath = "/";
        }
        ResourceStoreRequest result = new ResourceStoreRequest(resourceStorePath);
        result.getRequestContext().put(STOPWATCH_KEY, (Object)new Stopwatch().start());
        Subject subject = SecurityUtils.getSubject();
        if (subject != null && subject.getPrincipal() != null) {
            result.getRequestContext().put("request.user", (Object)subject.getPrincipal().toString());
        }
        result.getRequestContext().put("request.agent", (Object)request.getHeader("user-agent"));
        result.setRequestLocalOnly(this.isLocal(request, resourceStorePath));
        if (!Objects.equals(this.nexusConfiguration.getAnonymousUsername(), result.getRequestContext().get((Object)"request.user"))) {
            result.setRequestRemoteOnly(REQ_QP_FORCE_REMOTE_VALUE.equals(request.getParameter(REQ_QP_FORCE_PARAMETER)));
            result.setRequestAsExpired(REQ_QP_FORCE_EXPIRED_VALUE.equals(request.getParameter(REQ_QP_FORCE_PARAMETER)));
        }
        result.setExternal(true);
        long ifModifiedSince = request.getDateHeader("if-modified-since");
        if (ifModifiedSince > -1L) {
            result.setIfModifiedSince(ifModifiedSince);
        }
        if (!Strings.isNullOrEmpty((String)(ifNoneMatch = request.getHeader("if-none-match")))) {
            if (ifNoneMatch.startsWith("\"") && ifNoneMatch.endsWith("\"")) {
                ifNoneMatch = ifNoneMatch.substring(1, ifNoneMatch.length() - 1);
            }
            result.setIfNoneMatch(ifNoneMatch);
        }
        result.getRequestContext().put("request.address", (Object)RemoteIPFinder.findIP((HttpServletRequest)request));
        if (request.isSecure()) {
            List<X509Certificate> certs;
            result.getRequestContext().put("request.isConfidential", (Object)Boolean.TRUE);
            Object certArray = request.getAttribute("javax.servlet.request.X509Certificate");
            if (certArray != null && !(certs = Arrays.asList((X509Certificate[])certArray)).isEmpty()) {
                result.getRequestContext().put("request.certificates", certs);
            }
        }
        StringBuffer sb = request.getRequestURL();
        if (request.getQueryString() != null) {
            sb.append("?").append(request.getQueryString());
        }
        result.setRequestUrl(sb.toString());
        return result;
    }

    protected boolean isLocal(HttpServletRequest request, String resourceStorePath) {
        boolean isLocal = REQ_QP_FORCE_LOCAL_VALUE.equals(request.getParameter(REQ_QP_FORCE_PARAMETER));
        if (!Strings.isNullOrEmpty((String)resourceStorePath)) {
            isLocal = isLocal || resourceStorePath.endsWith("/");
        }
        return isLocal;
    }

    protected boolean isDescribeRequest(HttpServletRequest request) {
        return request.getParameterMap().containsKey(REQ_QP_DESCRIBE_PARAMETER);
    }

    private void handleException(HttpServletRequest request, Exception exception) throws ErrorStatusException, IOException {
        int responseCode;
        this.logger.trace("Exception", (Throwable)exception);
        if (exception instanceof LocalStorageEOFException) {
            responseCode = 404;
        } else if (exception instanceof IllegalArgumentException) {
            responseCode = 400;
        } else if (exception instanceof RemoteStorageTransportOverloadedException) {
            responseCode = 503;
        } else if (exception instanceof RepositoryNotAvailableException) {
            responseCode = 503;
        } else if (exception instanceof IllegalRequestException) {
            responseCode = 400;
        } else if (exception instanceof IllegalOperationException) {
            responseCode = 400;
        } else if (exception instanceof UnsupportedStorageOperationException) {
            responseCode = 400;
        } else if (exception instanceof NoSuchRepositoryException) {
            responseCode = 404;
        } else if (exception instanceof NoSuchResourceStoreException) {
            responseCode = 404;
        } else if (exception instanceof ItemNotFoundException) {
            responseCode = 404;
        } else {
            if (exception instanceof AccessDeniedException) {
                request.setAttribute("request.is.authz.rejected", (Object)Boolean.TRUE);
                return;
            }
            if (exception instanceof IOException) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("{} {}", new Object[]{exception.toString(), this.requestDetails(request), exception});
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("{} {}", (Object)Throwables2.explain((Throwable)exception), (Object)this.requestDetails(request));
                }
                throw (IOException)exception;
            }
            responseCode = 500;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("{} {}", new Object[]{exception.getMessage(), this.requestDetails(request), exception});
            }
        }
        throw new ErrorStatusException(responseCode, null, exception.getMessage());
    }

    private String requestDetails(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append("[client=").append(request.getRemoteAddr());
        sb.append(",ua=").append(request.getHeader("User-Agent"));
        sb.append(",req=").append(request.getMethod()).append(' ').append(request.getRequestURL().toString());
        sb.append(']');
        return sb.toString();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method;
        response.setHeader("Accept-Ranges", "bytes");
        switch (method = request.getMethod()) {
            case "GET": 
            case "HEAD": {
                this.doGet(request, response);
                break;
            }
            case "PUT": 
            case "POST": {
                this.doPut(request, response);
                break;
            }
            case "DELETE": {
                this.doDelete(request, response);
                break;
            }
            case "OPTIONS": {
                this.doOptions(request, response);
                break;
            }
            case "TRACE": {
                this.doTrace(request, response);
                break;
            }
            default: {
                throw new ErrorStatusException(405, null, "Method not supported: " + method);
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block11: {
            ResourceStoreRequest rsr = this.getResourceStoreRequest(request);
            try {
                try {
                    StorageItem item = this.repositoryRouter.retrieveItem(rsr);
                    if (item instanceof StorageLinkItem) {
                        StorageLinkItem link = (StorageLinkItem)item;
                        if (DEREFERENCE_LINKS) {
                            item = this.dereferenceLink(link);
                        } else {
                            this.webUtils.sendTemporaryRedirect(response, this.getLinkTargetUrl(link));
                            return;
                        }
                    }
                    ((Stopwatch)rsr.getRequestContext().get((Object)STOPWATCH_KEY)).stop();
                    if (this.isDescribeRequest(request)) {
                        this.doGetDescribe(request, response, rsr, item, null);
                        break block11;
                    }
                    if (item instanceof StorageFileItem) {
                        this.doGetFile(request, response, (StorageFileItem)item);
                        break block11;
                    }
                    if (item instanceof StorageCollectionItem) {
                        this.doGetCollection(request, response, (StorageCollectionItem)item);
                        break block11;
                    }
                    throw new ServletException("Item type " + item.getClass() + " unsupported!");
                }
                catch (ItemNotFoundException e) {
                    ((Stopwatch)rsr.getRequestContext().get((Object)STOPWATCH_KEY)).stop();
                    if (this.isDescribeRequest(request)) {
                        this.doGetDescribe(request, response, rsr, null, (Exception)((Object)e));
                        break block11;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                this.handleException(request, e);
            }
        }
    }

    protected StorageItem dereferenceLink(StorageLinkItem link) throws Exception {
        String hop;
        ArrayList hops = Lists.newArrayList();
        StorageLinkItem currentLink = link;
        while (!hops.contains(hop = currentLink.getRepositoryItemUid().getKey())) {
            hops.add(hop);
            StorageItem item = this.repositoryRouter.dereferenceLink(currentLink);
            if (!(item instanceof StorageLinkItem)) {
                return item;
            }
            currentLink = (StorageLinkItem)item;
        }
        throw new ItemNotFoundException((ItemNotFoundException.ItemNotFoundReason)ItemNotFoundException.reasonFor((ResourceStoreRequest)link.getResourceStoreRequest(), (Repository)link.getRepositoryItemUid().getRepository(), (String)"Link item %s introduced a cycle while referencing it, cycle is %s", (Object[])new Object[]{link.getRepositoryItemUid(), hops}));
    }

    protected String getLinkTargetUrl(StorageLinkItem link) {
        RepositoryItemUid targetUid = link.getTarget();
        return BaseUrlHolder.get() + "/content/repositories/" + targetUid.getRepository().getId() + targetUid.getPath();
    }

    protected void doGetFile(HttpServletRequest request, HttpServletResponse response, StorageFileItem file) throws ServletException, IOException {
        String etag;
        if (!file.isContentGenerated() && !file.isVirtual() && file.getRepositoryItemAttributes().containsKey("digest.sha1")) {
            etag = "{SHA1{" + file.getRepositoryItemAttributes().get("digest.sha1") + "}}";
            response.setHeader("ETag", "\"" + etag + "\"");
        } else {
            etag = null;
        }
        if (!file.isContentGenerated() && file.getResourceStoreRequest().getIfModifiedSince() != 0L && file.getModified() <= file.getResourceStoreRequest().getIfModifiedSince()) {
            response.setStatus(304);
            return;
        }
        if (!file.isContentGenerated() && file.getResourceStoreRequest().getIfNoneMatch() != null && etag != null && file.getResourceStoreRequest().getIfNoneMatch().equals(etag)) {
            response.setStatus(304);
            return;
        }
        response.setHeader("Content-Type", file.getMimeType());
        response.setDateHeader("Last-Modified", file.getModified());
        if (file.getLength() != -1L) {
            response.setHeader("Content-Length", String.valueOf(file.getLength()));
        }
        List<Range<Long>> ranges = this.getRequestedRanges(request, file.getLength());
        boolean contentNeeded = "GET".equalsIgnoreCase(request.getMethod());
        if (ranges.isEmpty()) {
            if (contentNeeded) {
                this.webUtils.sendContent(file.getInputStream(), response);
            }
        } else {
            if (ranges.size() > 1) {
                throw new ErrorStatusException(501, "Not Implemented", "Multiple ranges not yet supported.");
            }
            Range<Long> range = ranges.get(0);
            if (!this.isRequestedRangeSatisfiable(file, range)) {
                response.setStatus(416);
                response.setHeader("Content-Length", "0");
                response.setHeader("Content-Range", "bytes */" + file.getLength());
                return;
            }
            long bodySize = 1L + (Long)range.upperEndpoint() - (Long)range.lowerEndpoint();
            response.setStatus(206);
            response.setHeader("Content-Length", String.valueOf(bodySize));
            response.setHeader("Content-Range", range.lowerEndpoint() + "-" + range.upperEndpoint() + "/" + file.getLength());
            if (contentNeeded) {
                try (InputStream in = file.getInputStream();){
                    in.skip((Long)range.lowerEndpoint());
                    this.webUtils.sendContent(ByteStreams.limit((InputStream)in, (long)bodySize), response);
                }
            }
        }
    }

    protected void doGetCollection(HttpServletRequest request, HttpServletResponse response, StorageCollectionItem coll) throws Exception {
        if (!coll.getResourceStoreRequest().getRequestUrl().endsWith("/")) {
            response.setStatus(302);
            response.addHeader("Location", coll.getResourceStoreRequest().getRequestUrl() + "/");
            return;
        }
        response.setDateHeader("Last-Modified", coll.getModified());
        if ("HEAD".equalsIgnoreCase(request.getMethod())) {
            return;
        }
        this.webUtils.addNoCacheResponseHeaders(response);
        Collection children = coll.list();
        this.contentRenderer.renderCollection(request, response, coll, children);
    }

    protected void doGetDescribe(HttpServletRequest request, HttpServletResponse response, ResourceStoreRequest rsr, StorageItem item, Exception e) throws IOException {
        this.webUtils.addNoCacheResponseHeaders(response);
        this.contentRenderer.renderRequestDescription(request, response, rsr, item, e);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResourceStoreRequest rsr = this.getResourceStoreRequest(request);
        try {
            this.repositoryRouter.storeItem(rsr, (InputStream)request.getInputStream(), null);
            ((Stopwatch)rsr.getRequestContext().get((Object)STOPWATCH_KEY)).stop();
            response.setStatus(201);
        }
        catch (Exception e) {
            ((Stopwatch)rsr.getRequestContext().get((Object)STOPWATCH_KEY)).stop();
            this.handleException(request, e);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResourceStoreRequest rsr = this.getResourceStoreRequest(request);
        try {
            this.repositoryRouter.deleteItem(rsr);
            response.setStatus(204);
            ((Stopwatch)rsr.getRequestContext().get((Object)STOPWATCH_KEY)).stop();
        }
        catch (Exception e) {
            ((Stopwatch)rsr.getRequestContext().get((Object)STOPWATCH_KEY)).stop();
            this.handleException(request, e);
        }
    }

    protected List<Range<Long>> getRequestedRanges(HttpServletRequest request, long contentLength) {
        String rangeHeader = request.getHeader("Range");
        if (!Strings.isNullOrEmpty((String)rangeHeader)) {
            try {
                if (rangeHeader.startsWith("bytes=") && rangeHeader.length() > 6 && !rangeHeader.contains(",")) {
                    String rangeValue = rangeHeader.substring(6, rangeHeader.length());
                    if (rangeValue.startsWith("-")) {
                        return Collections.singletonList(Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.parseLong(rangeValue.substring(1)))));
                    }
                    if (rangeValue.endsWith("-")) {
                        return Collections.singletonList(Range.closed((Comparable)Long.valueOf(Long.parseLong(rangeValue.substring(0, rangeValue.length() - 1))), (Comparable)Long.valueOf(contentLength - 1L)));
                    }
                    if (rangeValue.contains("-")) {
                        String[] parts = rangeValue.split("-");
                        return Collections.singletonList(Range.closed((Comparable)Long.valueOf(Long.parseLong(parts[0])), (Comparable)Long.valueOf(Long.parseLong(parts[1]))));
                    }
                    this.logger.info("Malformed HTTP Range value: {}, ignoring it", (Object)rangeHeader);
                } else {
                    this.logger.info("Nexus does not support non-byte or multiple HTTP Ranges, sending complete content: Range value {}", (Object)rangeHeader);
                }
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Problem parsing Range value: {}, ignoring it", (Object)rangeHeader, (Object)e);
                }
                this.logger.info("Problem parsing Range value: {}, ignoring it", (Object)rangeHeader);
            }
        }
        return Collections.emptyList();
    }

    protected boolean isRequestedRangeSatisfiable(StorageFileItem file, Range<Long> range) {
        return Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(file.getLength() - 1L)).encloses(range);
    }
}

