/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.internal;

import com.google.common.base.Preconditions;
import javax.servlet.ServletRequest;
import org.apache.shiro.authc.HostAuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;

public class ContentRestrictedToken
implements HostAuthenticationToken {
    private final Object principal;
    private final char[] credentials;
    private final String host;
    private final ServletRequest request;

    public ContentRestrictedToken(UsernamePasswordToken basis, ServletRequest request) {
        Preconditions.checkNotNull((Object)basis);
        this.principal = basis.getPrincipal();
        this.credentials = basis.getPassword();
        this.host = basis.getHost();
        this.request = (ServletRequest)Preconditions.checkNotNull((Object)request);
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public String getUsername() {
        return this.principal != null ? this.principal.toString() : null;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public String getHost() {
        return this.host;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "principal=" + this.principal + ", host='" + this.host + '\'' + '}';
    }
}

