/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import org.sonatype.nexus.content.internal.ContentAuthenticationFilter;
import org.sonatype.nexus.content.internal.ContentServlet;
import org.sonatype.nexus.guice.FilterChainModule;
import org.sonatype.nexus.security.filter.FilterProviderSupport;
import org.sonatype.nexus.security.filter.authz.NexusTargetMappingAuthorizationFilter;
import org.sonatype.nexus.web.internal.SecurityFilter;

@Named
public class ContentModule
extends AbstractModule {
    private static final String MOUNT_POINT = "/content";

    protected void configure() {
        this.bind(FilterProviderSupport.filterKey((String)"contentAuthcBasic")).to(ContentAuthenticationFilter.class).in(Singleton.class);
        this.bind(FilterProviderSupport.filterKey((String)"contentTperms")).toProvider(ContentTargetMappingFilterProvider.class);
        this.install((Module)new ServletModule(){

            protected void configureServlets() {
                this.serve("/content/*", new String[0]).with(ContentServlet.class);
                this.filter("/content/*", new String[0]).through(SecurityFilter.class);
            }
        });
        this.install((Module)new FilterChainModule(){

            protected void configure() {
                this.addFilterChain("/content/**", "noSessionCreation,contentAuthcBasic,contentTperms");
            }
        });
    }

    @Singleton
    static class ContentTargetMappingFilterProvider
    extends FilterProviderSupport {
        @Inject
        public ContentTargetMappingFilterProvider(NexusTargetMappingAuthorizationFilter filter) {
            super((Filter)filter);
            filter.setPathPrefix("/content(.*)");
            filter.setPathReplacement("@1");
        }
    }
}

