/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.internal;

import com.google.common.base.Throwables;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.sonatype.nexus.content.ContentRestrictionConstituent;
import org.sonatype.nexus.content.internal.ContentRestrictedToken;
import org.sonatype.nexus.security.filter.authc.AuthenticationTokenFactory;
import org.sonatype.nexus.security.filter.authc.NexusHttpAuthenticationFilter;

public class ContentAuthenticationFilter
extends NexusHttpAuthenticationFilter {
    private final List<ContentRestrictionConstituent> constituents;
    private List<AuthenticationTokenFactory> factories;
    private static final String RESTRICTED_ATTR = ContentRestrictedToken.class.getSimpleName();

    @Inject
    public ContentAuthenticationFilter(@Nullable List<ContentRestrictionConstituent> constituents, @Nullable List<AuthenticationTokenFactory> factories) {
        this.constituents = constituents;
        this.factories = factories;
        this.setApplicationName("Sonatype Nexus Repository Manager");
    }

    private boolean isRestricted(ServletRequest request) {
        if (this.constituents != null) {
            for (ContentRestrictionConstituent constituent : this.constituents) {
                if (!constituent.isContentRestricted(request)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getUnauthorizedMessage(ServletRequest request) {
        Object attr = request.getAttribute(RESTRICTED_ATTR);
        if (attr != null) {
            return "Content access is protected by token";
        }
        return super.getUnauthorizedMessage(request);
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        if (this.isRestricted(request)) {
            this.getLogger().debug("Content authentication for request is restricted");
            request.setAttribute(RESTRICTED_ATTR, (Object)true);
            UsernamePasswordToken basis = (UsernamePasswordToken)super.createToken(request, response);
            return new ContentRestrictedToken(basis, request);
        }
        AuthenticationToken token = this.createAuthenticationToken(request, response);
        if (token != null) {
            return token;
        }
        return super.createToken(request, response);
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (!this.isRestricted(request) && this.isLoginAttempt(request, response)) {
            try {
                return this.executeLogin(request, response) && super.isAccessAllowed(request, response, mappedValue);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return super.isAccessAllowed(request, response, mappedValue);
    }

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        if (this.isRestricted(request)) {
            return super.isLoginAttempt(request, response);
        }
        AuthenticationToken token = this.createAuthenticationToken(request, response);
        return token != null || super.isLoginAttempt(request, response);
    }

    private AuthenticationToken createAuthenticationToken(ServletRequest request, ServletResponse response) {
        if (this.factories != null) {
            for (AuthenticationTokenFactory factory : this.factories) {
                try {
                    AuthenticationToken token = factory.createToken(request, response);
                    if (token == null) continue;
                    this.getLogger().debug("Token '{}' created by {}", (Object)token, (Object)factory);
                    return token;
                }
                catch (Exception e) {
                    this.getLogger().warn("Factory {} failed to create an authentication token {}/{}", new Object[]{factory, e.getClass().getName(), e.getMessage(), this.getLogger().isDebugEnabled() ? e : null});
                }
            }
        }
        return null;
    }
}

