/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.lvo.strategy;

import java.io.IOException;
import java.util.Properties;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.plugins.lvo.DiscoveryRequest;
import org.sonatype.nexus.plugins.lvo.DiscoveryResponse;
import org.sonatype.nexus.plugins.lvo.DiscoveryStrategy;
import org.sonatype.nexus.plugins.lvo.strategy.AbstractRemoteDiscoveryStrategy;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;

@Singleton
@Named(value="http-get-properties")
@Typed(value={DiscoveryStrategy.class})
public class HttpGetPropertiesDiscoveryStrategy
extends AbstractRemoteDiscoveryStrategy {
    @Inject
    public HttpGetPropertiesDiscoveryStrategy(Hc4Provider hc4Provider) {
        super(hc4Provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoveryResponse discoverLatestVersion(DiscoveryRequest request) throws NoSuchRepositoryException, IOException {
        DiscoveryResponse dr = new DiscoveryResponse(request);
        AbstractRemoteDiscoveryStrategy.RequestResult response = this.handleRequest(this.getRemoteUrl(request));
        if (response != null) {
            Properties properties = new Properties();
            try {
                properties.load(response.getInputStream());
            }
            finally {
                response.close();
            }
            String keyPrefix = request.getKey() + ".";
            for (Object key : properties.keySet()) {
                String keyString = key.toString();
                if (!keyString.startsWith(keyPrefix)) continue;
                dr.getResponse().put(key.toString().substring(keyPrefix.length()), properties.get(key));
                dr.setSuccessful(true);
            }
        } else {
            dr.setSuccessful(false);
        }
        return dr;
    }
}

