/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.lvo.strategy;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDomDriver;
import java.io.IOException;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.plugins.lvo.DiscoveryRequest;
import org.sonatype.nexus.plugins.lvo.DiscoveryResponse;
import org.sonatype.nexus.plugins.lvo.DiscoveryStrategy;
import org.sonatype.nexus.plugins.lvo.strategy.AbstractRemoteDiscoveryStrategy;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;

@Singleton
@Named(value="http-get-lvo")
@Typed(value={DiscoveryStrategy.class})
public class HttpGetLvoDiscoveryStrategy
extends AbstractRemoteDiscoveryStrategy {
    private XStream xstream;

    @Inject
    public HttpGetLvoDiscoveryStrategy(Hc4Provider hc4Provider) {
        super(hc4Provider);
    }

    protected synchronized XStream getXStream() {
        if (this.xstream == null) {
            this.xstream = new XStream((HierarchicalStreamDriver)new XppDomDriver());
            DiscoveryResponse.configureXStream(this.xstream);
        }
        return this.xstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoveryResponse discoverLatestVersion(DiscoveryRequest request) throws NoSuchRepositoryException, IOException {
        DiscoveryResponse dr = new DiscoveryResponse(request);
        AbstractRemoteDiscoveryStrategy.RequestResult response = this.handleRequest(this.getRemoteUrl(request));
        if (response != null) {
            try {
                DiscoveryResponse remoteResponse;
                DiscoveryResponse discoveryResponse = remoteResponse = (DiscoveryResponse)this.getXStream().fromXML(response.getInputStream());
                return discoveryResponse;
            }
            catch (XStreamException e) {
                dr.setSuccessful(false);
                DiscoveryResponse discoveryResponse = dr;
                return discoveryResponse;
            }
            finally {
                response.close();
            }
        }
        return dr;
    }
}

