/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.lvo.strategy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.plugins.lvo.DiscoveryRequest;
import org.sonatype.nexus.plugins.lvo.DiscoveryResponse;
import org.sonatype.nexus.plugins.lvo.DiscoveryStrategy;
import org.sonatype.nexus.plugins.lvo.strategy.ContentGetDiscoveryStrategy;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;

@Singleton
@Named(value="content-get-properties")
@Typed(value={DiscoveryStrategy.class})
public class ContentGetPropertiesDiscoveryStrategy
extends ContentGetDiscoveryStrategy {
    @Inject
    public ContentGetPropertiesDiscoveryStrategy(RepositoryRegistry repositoryRegistry) {
        super(repositoryRegistry);
    }

    @Override
    public DiscoveryResponse discoverLatestVersion(DiscoveryRequest request) throws NoSuchRepositoryException, IOException {
        DiscoveryResponse dr = new DiscoveryResponse(request);
        StorageFileItem response = this.handleRequest(request);
        if (response != null) {
            Properties properties = new Properties();
            InputStream content = response.getInputStream();
            Object object = null;
            try {
                properties.load(content);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (content != null) {
                    if (object != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        content.close();
                    }
                }
            }
            String keyPrefix = request.getKey() + ".";
            for (Object e : properties.keySet()) {
                String keyString = e.toString();
                if (!keyString.startsWith(keyPrefix)) continue;
                dr.getResponse().put(e.toString().substring(keyPrefix.length()), properties.get(e));
                dr.setSuccessful(true);
            }
        }
        return dr;
    }
}

