/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.lvo.strategy;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.plugins.lvo.DiscoveryRequest;
import org.sonatype.nexus.plugins.lvo.DiscoveryResponse;
import org.sonatype.nexus.plugins.lvo.DiscoveryStrategy;
import org.sonatype.nexus.plugins.lvo.strategy.AbstractDiscoveryStrategy;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;

@Singleton
@Named(value="content-get")
@Typed(value={DiscoveryStrategy.class})
public class ContentGetDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private final RepositoryRegistry repositoryRegistry;

    @Inject
    public ContentGetDiscoveryStrategy(RepositoryRegistry repositoryRegistry) {
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
    }

    @Override
    public DiscoveryResponse discoverLatestVersion(DiscoveryRequest request) throws NoSuchRepositoryException, IOException {
        DiscoveryResponse dr = new DiscoveryResponse(request);
        StorageFileItem response = this.handleRequest(request);
        if (response != null) {
            try (InputStream is = response.getInputStream();){
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                dr.setVersion(bos.toString());
                dr.setSuccessful(true);
            }
        }
        return dr;
    }

    protected StorageFileItem handleRequest(DiscoveryRequest request) {
        try {
            Repository repository = this.repositoryRegistry.getRepository(request.getLvoKey().getRepositoryId());
            StorageItem item = repository.retrieveItem(false, new ResourceStoreRequest(request.getLvoKey().getLocalPath()));
            if (item instanceof StorageFileItem) {
                return (StorageFileItem)item;
            }
            return null;
        }
        catch (Exception e) {
            this.log.warn("Could not retrieve content!", (Throwable)e);
            return null;
        }
    }
}

