/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.lvo.strategy;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.plugins.lvo.DiscoveryRequest;
import org.sonatype.nexus.plugins.lvo.strategy.AbstractDiscoveryStrategy;

public abstract class AbstractRemoteDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private final Hc4Provider hc4Provider;

    public AbstractRemoteDiscoveryStrategy(Hc4Provider hc4Provider) {
        this.hc4Provider = (Hc4Provider)Preconditions.checkNotNull((Object)hc4Provider);
    }

    protected RequestResult handleRequest(String url) {
        HttpClient client = this.hc4Provider.createHttpClient();
        HttpGet method = new HttpGet(url);
        RequestResult result = null;
        try {
            HttpResponse response = client.execute((HttpUriRequest)method);
            if (200 == response.getStatusLine().getStatusCode()) {
                result = new RequestResult(method, response);
            }
        }
        catch (IOException e) {
            this.log.debug("Error retrieving lvo data", (Throwable)e);
        }
        return result;
    }

    protected String getRemoteUrl(DiscoveryRequest request) {
        return request.getLvoKey().getRemoteUrl();
    }

    protected static final class RequestResult {
        private final HttpGet method;
        private final InputStream is;

        public RequestResult(HttpGet method, HttpResponse response) throws IOException {
            this.method = (HttpGet)Preconditions.checkNotNull((Object)method);
            this.is = response.getEntity().getContent();
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public void close() {
            IOUtils.closeQuietly((InputStream)this.is);
            this.method.releaseConnection();
        }
    }
}

