/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.lvo.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.configuration.ModelUtils;
import org.sonatype.nexus.configuration.ModelloUtils;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.plugins.lvo.NoSuchKeyException;
import org.sonatype.nexus.plugins.lvo.config.LvoPluginConfiguration;
import org.sonatype.nexus.plugins.lvo.config.model.CLvoKey;
import org.sonatype.nexus.plugins.lvo.config.model.Configuration;
import org.sonatype.nexus.plugins.lvo.config.model.io.xpp3.NexusLvoPluginConfigurationXpp3Reader;
import org.sonatype.nexus.plugins.lvo.config.model.io.xpp3.NexusLvoPluginConfigurationXpp3Writer;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultLvoPluginConfiguration
extends ComponentSupport
implements LvoPluginConfiguration {
    private final File configurationFile;
    private final LvoModelReader lvoModelReader;
    private final LvoModelWriter lvoModelWriter;
    private Configuration configuration;

    @Inject
    public DefaultLvoPluginConfiguration(ApplicationConfiguration applicationConfiguration) throws IOException {
        Preconditions.checkNotNull((Object)applicationConfiguration);
        this.configurationFile = new File(applicationConfiguration.getConfigurationDirectory(), "lvo-plugin.xml");
        this.lvoModelReader = new LvoModelReader();
        this.lvoModelWriter = new LvoModelWriter();
        this.configuration = this.load();
    }

    @Override
    public synchronized CLvoKey getLvoKey(String key) throws NoSuchKeyException {
        if (StringUtils.isEmpty((String)key)) {
            throw new NoSuchKeyException(key);
        }
        try {
            Configuration c = this.getConfiguration();
            for (CLvoKey lvoKey : c.getLvoKeys()) {
                if (!key.equals(lvoKey.getKey())) continue;
                return lvoKey;
            }
            throw new NoSuchKeyException(key);
        }
        catch (Exception e) {
            throw new NoSuchKeyException(key);
        }
    }

    @Override
    public synchronized boolean isEnabled() {
        try {
            return this.getConfiguration().isEnabled();
        }
        catch (IOException e) {
            this.log.error("Unable to read configuration", (Throwable)e);
            return false;
        }
    }

    @Override
    public synchronized void enable() throws IOException {
        this.getConfiguration().setEnabled(true);
        this.save();
    }

    @Override
    public synchronized void disable() throws IOException {
        this.getConfiguration().setEnabled(false);
        this.save();
    }

    protected Configuration getConfiguration() throws IOException {
        return this.configuration;
    }

    protected synchronized Configuration load() throws IOException {
        if (!this.configurationFile.exists()) {
            FileUtils.copyURLToFile((URL)this.getClass().getResource("/META-INF/nexus-lvo-plugin/lvo-plugin.xml"), (File)this.configurationFile);
        }
        return (Configuration)ModelloUtils.load((String)"2.8.0", (File)this.configurationFile, (ModelloUtils.ModelloModelReader)this.lvoModelReader, (ModelloUtils.ModelloModelUpgrader[])new ModelloUtils.ModelloModelUpgrader[]{new ModelloUtils.ModelloModelUpgrader("1.0.1", "2.8.0"){

            public void doUpgrade(Reader reader, Writer writer) throws IOException, XmlPullParserException {
                Configuration conf = new NexusLvoPluginConfigurationXpp3Reader().read(reader);
                conf.setVersion("2.8.0");
                new NexusLvoPluginConfigurationXpp3Writer().write(writer, conf);
            }
        }});
    }

    protected synchronized void save() throws IOException {
        ModelloUtils.save((Object)this.configuration, (File)this.configurationFile, (ModelloUtils.ModelloModelWriter)this.lvoModelWriter);
    }

    private static class LvoModelWriter
    extends ModelloUtils.ModelloModelWriter<Configuration> {
        private final NexusLvoPluginConfigurationXpp3Writer modelloWriter = new NexusLvoPluginConfigurationXpp3Writer();

        private LvoModelWriter() {
        }

        public void write(Writer writer, Configuration model) throws IOException {
            model.setVersion("2.8.0");
            this.modelloWriter.write(writer, model);
        }
    }

    private static class LvoModelReader
    extends ModelloUtils.ModelloModelReader<Configuration>
    implements ModelUtils.Versioned {
        private final ModelloUtils.VersionedInFieldXmlModelloModelHelper versionedHelper = new ModelloUtils.VersionedInFieldXmlModelloModelHelper("version");
        private final NexusLvoPluginConfigurationXpp3Reader modelloReader = new NexusLvoPluginConfigurationXpp3Reader();

        private LvoModelReader() {
        }

        public Configuration doRead(Reader reader) throws IOException, XmlPullParserException {
            return this.modelloReader.read(reader);
        }

        public String readVersion(InputStream input) throws IOException, ModelUtils.CorruptModelException {
            String version = this.versionedHelper.readVersion(input);
            if ("1.0.0".equals(version)) {
                return "1.0.1";
            }
            return version;
        }
    }
}

