/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.lvo.api;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.plugins.lvo.DiscoveryResponse;
import org.sonatype.nexus.plugins.lvo.LvoService;
import org.sonatype.nexus.plugins.lvo.NoSuchKeyException;
import org.sonatype.nexus.plugins.lvo.NoSuchStrategyException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.plexus.rest.resource.AbstractPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
public class LvoQueryPlexusResource
extends AbstractPlexusResource {
    private final LvoService lvoService;

    @Inject
    public LvoQueryPlexusResource(LvoService lvoService) {
        this.lvoService = (LvoService)Preconditions.checkNotNull((Object)lvoService);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/lvo/*/*", "authcBasic,perms[nexus:status]");
    }

    public String getResourceUri() {
        return "/lvo/{key}/{currentVersion}";
    }

    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        String key = (String)request.getAttributes().get("key");
        String cv = (String)request.getAttributes().get("currentVersion");
        try {
            DiscoveryResponse dr = this.lvoService.queryLatestVersionForKey(key, cv);
            if (dr.isSuccessful()) {
                return dr;
            }
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "No version newer than '" + cv + "' for key='" + key + "' found.");
        }
        catch (NoSuchKeyException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage(), (Throwable)e);
        }
        catch (IOException | NoSuchStrategyException | NoSuchRepositoryException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, e.getMessage(), e);
        }
    }
}

