/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.lvo.api;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.plugins.lvo.api.dto.LvoConfigDTO;
import org.sonatype.nexus.plugins.lvo.api.dto.LvoConfigRequest;
import org.sonatype.nexus.plugins.lvo.api.dto.LvoConfigResponse;
import org.sonatype.nexus.plugins.lvo.config.LvoPluginConfiguration;
import org.sonatype.plexus.rest.resource.AbstractPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
public class LvoConfigPlexusResource
extends AbstractPlexusResource {
    private final LvoPluginConfiguration config;

    @Inject
    public LvoConfigPlexusResource(LvoPluginConfiguration config) {
        this.config = (LvoPluginConfiguration)Preconditions.checkNotNull((Object)config);
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new LvoConfigRequest();
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/lvo_config", "authcBasic,perms[nexus:settings]");
    }

    public String getResourceUri() {
        return "/lvo_config";
    }

    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        this.config.isEnabled();
        LvoConfigResponse resp = new LvoConfigResponse();
        LvoConfigDTO dto = new LvoConfigDTO();
        dto.setEnabled(this.config.isEnabled());
        resp.setData(dto);
        return resp;
    }

    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        LvoConfigRequest req = (LvoConfigRequest)payload;
        try {
            if (req.getData().isEnabled()) {
                this.config.enable();
            } else {
                this.config.disable();
            }
        }
        catch (IOException | ConfigurationException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Unable to store lvo configuration", e);
        }
        return null;
    }
}

