/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.lvo;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionScheme;
import org.sonatype.nexus.plugins.lvo.DiscoveryRequest;
import org.sonatype.nexus.plugins.lvo.DiscoveryResponse;
import org.sonatype.nexus.plugins.lvo.DiscoveryStrategy;
import org.sonatype.nexus.plugins.lvo.LvoService;
import org.sonatype.nexus.plugins.lvo.NoSuchKeyException;
import org.sonatype.nexus.plugins.lvo.NoSuchStrategyException;
import org.sonatype.nexus.plugins.lvo.config.LvoPluginConfiguration;
import org.sonatype.nexus.plugins.lvo.config.model.CLvoKey;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultLvoService
extends ComponentSupport
implements LvoService {
    private final LvoPluginConfiguration lvoPluginConfiguration;
    private final Map<String, DiscoveryStrategy> strategies;
    private final VersionScheme versionScheme = new GenericVersionScheme();

    @Inject
    public DefaultLvoService(LvoPluginConfiguration lvoPluginConfiguration, Map<String, DiscoveryStrategy> strategies) {
        this.lvoPluginConfiguration = (LvoPluginConfiguration)Preconditions.checkNotNull((Object)lvoPluginConfiguration);
        this.strategies = (Map)Preconditions.checkNotNull(strategies);
    }

    @Override
    public DiscoveryResponse getLatestVersionForKey(String key) throws NoSuchKeyException, NoSuchStrategyException, NoSuchRepositoryException, IOException {
        if (this.lvoPluginConfiguration.isEnabled()) {
            CLvoKey info = this.lvoPluginConfiguration.getLvoKey(key);
            String strategyId = info.getStrategy();
            if (StringUtils.isEmpty((String)strategyId)) {
                this.log.warn("Misconfigured version check key '{}': strategy ID missing.", (Object)key);
                throw new NoSuchStrategyException(info.getStrategy());
            }
            if (this.strategies.containsKey(strategyId)) {
                DiscoveryStrategy strategy = this.strategies.get(strategyId);
                DiscoveryRequest req = new DiscoveryRequest(key, info);
                return strategy.discoverLatestVersion(req);
            }
            throw new NoSuchStrategyException(info.getStrategy());
        }
        return this.getDisabledResponse();
    }

    @Override
    public DiscoveryResponse queryLatestVersionForKey(String key, String v) throws NoSuchKeyException, NoSuchStrategyException, NoSuchRepositoryException, IOException {
        if (this.lvoPluginConfiguration.isEnabled()) {
            DiscoveryResponse response = this.getLatestVersionForKey(key);
            if (!response.isSuccessful()) {
                return response;
            }
            try {
                Version versionCurrent = this.versionScheme.parseVersion(v);
                Version versionReceived = this.versionScheme.parseVersion(response.getVersion());
                if (versionReceived.compareTo((Object)versionCurrent) <= 0) {
                    response.setSuccessful(false);
                }
            }
            catch (InvalidVersionSpecificationException e) {
                this.log.warn("Could not parse version ({}/{}/{})", (Object[])new String[]{key, v, response.getVersion()});
                response.setSuccessful(false);
            }
            return response;
        }
        return this.getDisabledResponse();
    }

    protected DiscoveryResponse getDisabledResponse() {
        DiscoveryResponse response = new DiscoveryResponse(null);
        response.setSuccessful(false);
        return response;
    }
}

