/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.resource.scanner.scanners;

import java.io.File;
import java.io.FileFilter;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.sisu.resource.scanner.Listener;
import org.sonatype.sisu.resource.scanner.Scanner;

@Named(value="serial")
@Singleton
public class SerialScanner
implements Scanner {
    @Override
    public void scan(File directory, Listener listener) {
        this.scan(directory, listener, null);
    }

    @Override
    public void scan(File directory, Listener listener, FileFilter filter) {
        if (listener == null) {
            return;
        }
        listener.onBegin();
        this.recurse(directory, listener, filter);
        listener.onEnd();
    }

    private void recurse(File directory, Listener listener, FileFilter filter) {
        File[] files;
        if (!directory.exists()) {
            return;
        }
        listener.onEnterDirectory(directory);
        File[] fileArray = files = filter == null ? directory.listFiles() : directory.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.recurse(file, listener, filter);
                    continue;
                }
                listener.onFile(file);
            }
        }
        listener.onExitDirectory(directory);
    }
}

