/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.resource.scanner.scanners;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingScanner {
    private static int __scannerId = 0;
    private int _scanInterval;
    private final List<Listener> _listeners = new ArrayList<Listener>();
    private final Map<String, Long> _prevScan = new HashMap<String, Long>();
    private final Map<String, Long> _currentScan = new HashMap<String, Long>();
    private FilenameFilter _filter;
    private final List<File> _scanDirs = new ArrayList<File>();
    private volatile boolean _running = false;
    private boolean _reportExisting = true;
    private boolean _reportDirs = true;
    private Timer _timer;
    private TimerTask _task;
    private int _scanDepth = 0;
    private static Logger logger = LoggerFactory.getLogger(PollingScanner.class);

    public int getScanInterval() {
        return this._scanInterval;
    }

    public synchronized void setScanInterval(int scanInterval) {
        this._scanInterval = scanInterval;
        this.schedule();
    }

    public void setScanDirs(List<File> dirs) {
        this._scanDirs.clear();
        this._scanDirs.addAll(dirs);
    }

    public void setScanDirs(File ... dirs) {
        this.setScanDirs(Arrays.asList(dirs));
    }

    public List<File> getScanDirs() {
        return Collections.unmodifiableList(this._scanDirs);
    }

    public void setRecursive(boolean recursive) {
        this._scanDepth = recursive ? -1 : 0;
    }

    public boolean getRecursive() {
        return this._scanDepth == -1;
    }

    public int getScanDepth() {
        return this._scanDepth;
    }

    public void setScanDepth(int scanDepth) {
        this._scanDepth = scanDepth;
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this._filter = filter;
    }

    public FilenameFilter getFilenameFilter() {
        return this._filter;
    }

    public void setReportExistingFilesOnStartup(boolean reportExisting) {
        this._reportExisting = reportExisting;
    }

    public boolean getReportExistingFilesOnStartup() {
        return this._reportExisting;
    }

    public void setReportDirs(boolean dirs) {
        this._reportDirs = dirs;
    }

    public boolean getReportDirs() {
        return this._reportDirs;
    }

    public synchronized void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public synchronized void start() {
        if (this._running) {
            return;
        }
        this._running = true;
        if (this._reportExisting) {
            this.scan();
        } else {
            this.scanFiles();
            this._prevScan.putAll(this._currentScan);
        }
        this.schedule();
    }

    public TimerTask newTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                PollingScanner.this.scan();
            }
        };
    }

    public Timer newTimer() {
        return new Timer("Scanner-" + __scannerId++, true);
    }

    public void schedule() {
        if (this._running) {
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            if (this.getScanInterval() > 0) {
                this._timer = this.newTimer();
                this._task = this.newTimerTask();
                this._timer.schedule(this._task, 1000L * (long)this.getScanInterval(), 1000L * (long)this.getScanInterval());
            }
        }
    }

    public synchronized void stop() {
        if (this._running) {
            this._running = false;
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            this._timer = null;
        }
    }

    public synchronized void scan() {
        this.scanFiles();
        this.reportDifferences(this._currentScan, this._prevScan);
        this._prevScan.clear();
        this._prevScan.putAll(this._currentScan);
    }

    public synchronized void scanFiles() {
        if (this._scanDirs == null) {
            return;
        }
        this._currentScan.clear();
        for (File dir : this._scanDirs) {
            if (dir == null || !dir.exists()) continue;
            try {
                this.scanFile(dir.getCanonicalFile(), this._currentScan, 0);
            }
            catch (IOException e) {
                logger.warn("Error scanning files.", (Throwable)e);
            }
        }
    }

    public void reportDifferences(Map<String, Long> currentScan, Map<String, Long> oldScan) {
        ArrayList<String> bulkChanges = new ArrayList<String>();
        HashSet<String> oldScanKeys = new HashSet<String>(oldScan.keySet());
        for (Map.Entry<String, Long> entry : currentScan.entrySet()) {
            if (!oldScanKeys.contains(entry.getKey())) {
                logger.debug("File added: " + entry.getKey());
                this.reportAddition(entry.getKey());
                bulkChanges.add(entry.getKey());
                continue;
            }
            if (!oldScan.get(entry.getKey()).equals(entry.getValue())) {
                logger.debug("File changed: " + entry.getKey());
                this.reportChange(entry.getKey());
                oldScanKeys.remove(entry.getKey());
                bulkChanges.add(entry.getKey());
                continue;
            }
            oldScanKeys.remove(entry.getKey());
        }
        if (!oldScanKeys.isEmpty()) {
            for (String filename : oldScanKeys) {
                logger.debug("File removed: " + filename);
                this.reportRemoval(filename);
                bulkChanges.add(filename);
            }
        }
        if (!bulkChanges.isEmpty()) {
            this.reportBulkChanges(bulkChanges);
        }
    }

    private void scanFile(File f, Map<String, Long> scanInfoMap, int depth) {
        try {
            if (!f.exists()) {
                return;
            }
            if ((f.isFile() || depth > 0 && this._reportDirs && f.isDirectory()) && (this._filter == null || this._filter != null && this._filter.accept(f.getParentFile(), f.getName()))) {
                String name = f.getCanonicalPath();
                long lastModified = f.lastModified();
                scanInfoMap.put(name, new Long(lastModified));
            }
            if (f.isDirectory() && (depth < this._scanDepth || this._scanDepth == -1 || this._scanDirs.contains(f))) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.scanFile(files[i], scanInfoMap, depth + 1);
                }
            }
        }
        catch (IOException e) {
            logger.warn("Error scanning watched files", (Throwable)e);
        }
    }

    private void warn(Object listener, String filename, Throwable th) {
        logger.warn(listener + " failed on '" + filename, th);
    }

    private void reportAddition(String filename) {
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileAdded(filename);
            }
            catch (Exception e) {
                this.warn(l, filename, e);
            }
            catch (Error e) {
                this.warn(l, filename, e);
            }
        }
    }

    private void reportRemoval(String filename) {
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileRemoved(filename);
            }
            catch (Exception e) {
                this.warn(l, filename, e);
            }
            catch (Error e) {
                this.warn(l, filename, e);
            }
        }
    }

    private void reportChange(String filename) {
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileChanged(filename);
            }
            catch (Exception e) {
                this.warn(l, filename, e);
            }
            catch (Error e) {
                this.warn(l, filename, e);
            }
        }
    }

    private void reportBulkChanges(List<String> filenames) {
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof BulkListener)) continue;
                ((BulkListener)l).filesChanged(filenames);
            }
            catch (Exception e) {
                this.warn(l, filenames.toString(), e);
            }
            catch (Error e) {
                this.warn(l, filenames.toString(), e);
            }
        }
    }

    public static interface BulkListener
    extends Listener {
        public void filesChanged(List<String> var1) throws Exception;
    }

    public static interface DiscreteListener
    extends Listener {
        public void fileChanged(String var1) throws Exception;

        public void fileAdded(String var1) throws Exception;

        public void fileRemoved(String var1) throws Exception;
    }

    public static interface Listener {
    }
}

