/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.resource.scanner.scanners;

import java.io.File;
import java.io.FileFilter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.sisu.resource.scanner.Listener;
import org.sonatype.sisu.resource.scanner.Scanner;

@Named(value="parallel")
@Singleton
public class ParallelScanner
implements Scanner {
    private final ExecutorService executor;
    private final Semaphore sem = new Semaphore(1);
    private final AtomicInteger count = new AtomicInteger();
    private final ParallelisationStrategy parallelisationStrategy;
    public static ParallelisationStrategy EVERY_DIRECTORY = new ParallelisationStrategy(){

        @Override
        public boolean shouldScanInParallel(File directory) {
            return true;
        }
    };
    public static ParallelisationStrategy NEVER = new ParallelisationStrategy(){

        @Override
        public boolean shouldScanInParallel(File directory) {
            return false;
        }
    };

    public ParallelScanner(@Named(value="${scanner.parallel.threads}") int threads) {
        this(threads, EVERY_DIRECTORY);
    }

    @Inject
    public ParallelScanner(@Named(value="${scanner.parallel.threads}") int threads, @Nullable ParallelisationStrategy parallelisationStrategy) {
        this.parallelisationStrategy = parallelisationStrategy == null ? EVERY_DIRECTORY : parallelisationStrategy;
        this.executor = Executors.newFixedThreadPool(threads);
    }

    @Override
    public void scan(File directory, Listener listener) {
        this.scan(directory, listener, null);
    }

    @Override
    public void scan(File directory, Listener listener, FileFilter filter) {
        if (listener == null) {
            return;
        }
        try {
            listener.onBegin();
            if (directory.exists()) {
                this.sem.acquire();
                this.recurse(directory, listener, filter);
                this.sem.acquire();
            }
            listener.onEnd();
            this.executor.shutdown();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void recurse(File directory, final Listener listener, final FileFilter filter) {
        File[] files;
        listener.onEnterDirectory(directory);
        File[] fileArray = files = filter == null ? directory.listFiles() : directory.listFiles(filter);
        if (files != null) {
            for (final File file : files) {
                if (file.isDirectory()) {
                    if (this.parallelisationStrategy.shouldScanInParallel(file)) {
                        this.count.incrementAndGet();
                        this.executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                ParallelScanner.this.recurse(file, listener, filter);
                            }
                        });
                        continue;
                    }
                    this.recurse(file, listener, filter);
                    continue;
                }
                listener.onFile(file);
            }
        }
        listener.onExitDirectory(directory);
        if (this.count.decrementAndGet() < 0) {
            this.sem.release();
        }
    }

    public void close() {
        this.executor.shutdown();
    }

    public static interface ParallelisationStrategy {
        public boolean shouldScanInParallel(File var1);
    }
}

