/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.resource.scanner.scanners;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.sisu.resource.scanner.Listener;
import org.sonatype.sisu.resource.scanner.Scanner;

@Named(value="fairness")
@Singleton
public class FairnessScanner
implements Scanner {
    private final Semaphore sem = new Semaphore(1);
    private final AtomicInteger waitingCount = new AtomicInteger(0);
    private final List<ThreadWithList> threads = new ArrayList<ThreadWithList>();
    private final int installmentSize;
    private final BlockingQueue<DirInfo> queue;
    private static final List<FairnessScanner> scanners = new ArrayList<FairnessScanner>();

    @Inject
    public FairnessScanner(@Named(value="${sisu.scanner.fairness.threads}") int threads, @Named(value="${sisu.scanner.fairness.installmentSize}") int installmentSize) {
        this.installmentSize = installmentSize;
        this.queue = new LinkedBlockingQueue<DirInfo>();
        for (int i = 0; i < threads; ++i) {
            ThreadWithList t = new ThreadWithList();
            this.threads.add(t);
        }
    }

    @Override
    public void scan(File directory, Listener listener) {
        this.scan(directory, listener, null);
    }

    @Override
    public void scan(File directory, Listener listener, FileFilter filter) {
        try {
            this.sem.acquire();
            this.queue.add(new DirInfo(directory, filter));
            for (ThreadWithList t : this.threads) {
                t.start();
            }
            this.sem.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ArrayList ret = new ArrayList();
        for (ThreadWithList t : this.threads) {
            ret.addAll(t.files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recurse() {
        this.waitingCount.incrementAndGet();
        ThreadWithList thread = (ThreadWithList)Thread.currentThread();
        DirInfo dirInfo = null;
        try {
            if (this.waitingCount.get() == this.threads.size() && this.queue.isEmpty()) {
                this.sem.release();
                boolean bl = true;
                return bl;
            }
            dirInfo = this.queue.take();
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            boolean bl = true;
            return bl;
        }
        finally {
            this.waitingCount.decrementAndGet();
        }
        int index = dirInfo.getIndex();
        File[] listing = dirInfo.getListing();
        int upperBound = Math.min(index + this.installmentSize, listing.length);
        for (int i = index; i < upperBound; ++i) {
            thread.files.add(listing[i]);
            if (!listing[i].isDirectory()) continue;
            DirInfo subdirInfo = new DirInfo(listing[i], dirInfo.getFilter());
            try {
                this.queue.put(subdirInfo);
                continue;
            }
            catch (InterruptedException exc) {
                Thread.currentThread().interrupt();
                return true;
            }
        }
        if (upperBound != listing.length) {
            dirInfo.setIndex(upperBound);
            this.queue.add(dirInfo);
        }
        thread.useCount += upperBound - index;
        return false;
    }

    public void close() {
        for (ThreadWithList t : this.threads) {
            if (!t.isAlive()) continue;
            t.interrupt();
        }
        for (ThreadWithList t : this.threads) {
            try {
                t.files.clear();
                t.join();
                System.out.print(t.getUseCount() + " ");
            }
            catch (InterruptedException exc) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        System.out.println();
        this.queue.clear();
    }

    public static void flush() {
        for (FairnessScanner scanner : scanners) {
            scanner.close();
        }
    }

    private final class ThreadWithList
    extends Thread {
        private final List<File> files = new ArrayList<File>();
        private int useCount = 0;

        public int getUseCount() {
            return this.useCount;
        }

        @Override
        public void run() {
            while (!FairnessScanner.this.recurse()) {
            }
        }
    }

    private static class DirInfo {
        private final File[] listing;
        private int index;
        private final FileFilter filter;

        public DirInfo(File directory, FileFilter filter) {
            this.filter = filter;
            this.listing = filter == null ? directory.listFiles() : directory.listFiles(filter);
            this.index = 0;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public File[] getListing() {
            return this.listing;
        }

        public FileFilter getFilter() {
            return this.filter;
        }
    }
}

