/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.resource.scanner.helper;

import java.io.File;
import org.sonatype.sisu.resource.scanner.Listener;

public abstract class CompositeListenerExceptionPolicy {
    public abstract void onBegin(Listener var1, Exception var2);

    public abstract void onEnterDirectory(Listener var1, Exception var2, File var3);

    public abstract void onExitDirectory(Listener var1, Exception var2, File var3);

    public abstract void onFile(Listener var1, Exception var2, File var3);

    public abstract void onEnd(Listener var1, Exception var2);

    public static final CompositeListenerExceptionPolicy ignore() {
        return new CompositeListenerExceptionPolicy(){

            @Override
            public void onBegin(Listener listener, Exception e) {
            }

            @Override
            public void onEnterDirectory(Listener listener, Exception e, File directory) {
            }

            @Override
            public void onExitDirectory(Listener listener, Exception e, File directory) {
            }

            @Override
            public void onFile(Listener listener, Exception e, File file) {
            }

            @Override
            public void onEnd(Listener listener, Exception e) {
            }
        };
    }

    public static final CompositeListenerExceptionPolicy rethrow() {
        return new CompositeListenerExceptionPolicy(){

            @Override
            public void onBegin(Listener listener, Exception e) {
                throw new RuntimeException(String.format("Listener [%s] failed to execute on begining of processing with exception [%s]", listener, e.getMessage()), e);
            }

            @Override
            public void onEnterDirectory(Listener listener, Exception e, File directory) {
                throw new RuntimeException(String.format("Listener [%s] failed to entering directory [%s] execute with exception [%s]", listener, directory.getAbsolutePath(), e.getMessage()), e);
            }

            @Override
            public void onExitDirectory(Listener listener, Exception e, File directory) {
                throw new RuntimeException(String.format("Listener [%s] failed to execute on exiting directory [%s] with exception [%s]", listener, directory.getAbsolutePath(), e.getMessage()), e);
            }

            @Override
            public void onFile(Listener listener, Exception e, File file) {
                throw new RuntimeException(String.format("Listener [%s] failed to execute on file [%s] with exception [%s]", listener, file.getAbsolutePath(), e.getMessage()), e);
            }

            @Override
            public void onEnd(Listener listener, Exception e) {
                throw new RuntimeException(String.format("Listener [%s] failed to execute on ending of processing with exception [%s]", listener, e.getMessage()), e);
            }
        };
    }
}

